/**
 * 
 */
package org.gcube.accounting.datamodel.implementations.aggregated;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class StorageUsageRecord extends org.gcube.accounting.datamodel.implementations.StorageUsageRecord implements AggregatedUsageRecord<StorageUsageRecord> {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 1082525518686785682L;
	
	public StorageUsageRecord(){
		super();
		this.resourceProperties.put(AGGREGATED, true);
	}
	
	public StorageUsageRecord(Map<String, Serializable> properties) throws InvalidValueException{
		super(properties);
		this.resourceProperties.put(AGGREGATED, true);
	}
		
	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<StorageUsageRecord> aggregate(List<StorageUsageRecord> records) {
		// TODO
		throw new UnsupportedOperationException();
	}
}
