/**
 * 
 */
package org.gcube.accounting.persistence;

import java.io.Serializable;
import java.util.Map;

import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.http.StdHttpClient.Builder;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.impl.StdCouchDbInstance;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class CouchDBPersistence  extends Persistence {
	
	private static final Logger logger = LoggerFactory.getLogger(CouchDBPersistence.class);
	
	protected CouchDbInstance couchDbInstance;
	protected CouchDbConnector couchDbConnector;
	
	protected final static String HOST = "HOST";
	protected final static String DEFAULT_HOST = "localhost";
	protected final static String PORT = "PORT";
	protected final static String USERNAME = "USERNAME";
	protected final static String PASSWORD = "PASSWORD";
	
	protected String host = "localhost";
	protected int port = 5984;
	protected String username = "";
	protected String password = "";
	protected String dbName = "accounting";
	
	protected CouchDBPersistence() throws Exception {
		super();
	}
	
	protected HttpClient initHttpClient(String uri, int port, String username, String password){
		Builder builder = new StdHttpClient.Builder().host(uri).port(port); 
		if(username!=null && username.compareTo("")!=0 && 
		   password!=null && password.compareTo("")!=0){
			builder.username(username).password(password);
		}
		HttpClient httpClient = builder.build();
		return httpClient;
	}
	
	protected ViewResult query(ViewQuery query){
		ViewResult result = couchDbConnector.queryView(query);
		return result;
	}
	
	
	@Override
	public void close() throws Exception {
		couchDbConnector.getConnection().shutdown();
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void prepareConnection() throws Exception {
		logger.debug("Preparing Connection for {}", this.getClass().getSimpleName());
		HttpClient httpClient = initHttpClient(host, port, username, password);
		couchDbInstance = new StdCouchDbInstance(httpClient);
		couchDbConnector = new StdCouchDbConnector(dbName, couchDbInstance);
		couchDbConnector.createDatabaseIfNotExists(); // TODO remove this
	}
	
	protected void createItem(JsonNode node, String id) throws Exception {
		if(id!=null && id.compareTo("")!=0){
			couchDbConnector.create(id, node);
		}else{
			couchDbConnector.create(node);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void reallyAccount(UsageRecord usageRecord) throws Exception {
		JsonNode node = usageRecordToJsonNode(usageRecord);
		createItem(node, usageRecord.getId());
	}
	
	public static JsonNode usageRecordToJsonNode(UsageRecord usageRecord) throws Exception {
		ObjectMapper mapper = new ObjectMapper();
		JsonNode node = mapper.valueToTree(usageRecord.getResourceProperties());
		return node;
	}
	
	public static UsageRecord jsonNodeToUsageRecord(JsonNode jsonNode) throws Exception {
		ObjectMapper mapper = new ObjectMapper();
		@SuppressWarnings("unchecked")
		Map<String, Serializable> result = mapper.convertValue(jsonNode, Map.class);
		UsageRecord usageRecord = BasicUsageRecord.getUsageRecord(result);
		return usageRecord;
	}
	
}
