/**
 * 
 */
package org.gcube.accounting.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import org.gcube.accounting.datamodel.UsageRecord;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class FallbackPersistence extends Persistence {
	
	private File accountingFallbackFile; 
	
	protected FallbackPersistence(File accountingFallbackFile) {
		super();
		this.accountingFallbackFile = accountingFallbackFile;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void prepareConnection() {
		// Nothing TO DO
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void reallyAccount(UsageRecord usageRecord) throws Exception {
		try(FileWriter fw = new FileWriter(accountingFallbackFile, true);
			BufferedWriter bw = new BufferedWriter(fw);
			PrintWriter out = new PrintWriter(bw)){
				out.println(usageRecord);
		} catch( IOException e ){
		   throw e;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void close() throws Exception {
		// Nothing TO DO
	}
	
}
