/**
 * 
 */
package org.gcube.accounting.datamodel.deprecationmanagement.validators;

import java.io.Serializable;

import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.exception.InvalidValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class DeprecatedWarningAction implements FieldAction {
	
	private static Logger logger = LoggerFactory.getLogger(DeprecatedWarningAction.class);
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException  {
		logger.warn("The field {} is deprecated for {}. Anyway the field will be included in the document", 
				key, usageRecord.getClass().getSimpleName());
		return value;
	}
	
}
