/**
 * 
 */
package org.gcube.accounting.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;

import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.decorators.AggregatedField;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * This Class is for library internal use only
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class StorageUsageRecord extends org.gcube.accounting.datamodel.basetypes.StorageUsageRecord implements AggregatedUsageRecord<StorageUsageRecord, org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord> {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 1082525518686785682L;
	
	// Redefining DATA_VOLUME to Set @AggregatedField
	@RequiredField @ValidLong @AggregatedField
	public static final String DATA_VOLUME = org.gcube.accounting.datamodel.basetypes.StorageUsageRecord.DATA_VOLUME;
		
	private void init(){
		this.resourceProperties.put(AGGREGATED, true);
	}
	
	public StorageUsageRecord() {
		super();
		init();
	}
	
	public StorageUsageRecord(Map<String, Serializable> properties) throws InvalidValueException{
		super(properties);
		init();
	}

	public StorageUsageRecord(org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord record) throws InvalidValueException{
		super(record.getResourceProperties());
		this.setOperationCount(1);
		Calendar creationTime = record.getCreationTime();
		this.setCreationTime(Calendar.getInstance());
		this.setStartTime(creationTime);
		this.setEndTime(creationTime);
		init();
		
	}
	
	@Override
	public int getOperationCount() {
		return super.getOperationCount();
	}

	@Override
	public void setOperationCount(int operationCount) throws InvalidValueException {
		super.setOperationCount(operationCount);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public StorageUsageRecord getAggregatedUsageRecord(
			org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord usageRecord)
			throws InvalidValueException {
		return new StorageUsageRecord(usageRecord);
	}
	
}
