/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.basetypes;

import java.net.URI;
import java.net.URISyntaxException;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.StorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.JobUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUsageRecord {
    private static final Logger logger = LoggerFactory.getLogger(TestUsageRecord.class);
    public static final String TEST_CONSUMER_ID = "name.surname";
    public static final String TEST_SCOPE = "/infrastructure/vo";
    public static final String TEST_SERVICE_CLASS = "TestServiceClass";
    public static final String TEST_SERVICE_NAME = "TestServiceName";
    public static final String TEST_CALLED_METHOD = "TestCalledMethod";
    public static final String TEST_CALLER_HOST = "remotehost";
    public static final String TEST_HOST = "localhost";
    public static final String TEST_PROPERTY_NAME = "TestPropertyName";
    public static final String TEST_PROPERTY_VALUE = "TestPropertyValue";
    private static final long MIN_DURATION = 60L;
    private static final long MAX_DURATION = 1000L;
    public static final String TEST_RESOUCE_OWNER = "resource.owner";
    public static final String TEST_RESOUCE_SCOPE = "/infrastructure/vo";
    public static final String TEST_RESOURCE_URI = "testprotocol://objectURI";
    public static final String TEST_PROVIDER_URI = "testprotocol://providerURI";
    private static final long MIN_DATA_VOLUME = 1024L;
    private static final long MAX_DATA_VOLUME = 10240L;

    public static long generateRandomLong(long min, long max) {
        return min + (long)((int)(Math.random() * (double)(max - min + 1L)));
    }

    public static ServiceUsageRecord createTestServiceUsageRecord() {
        ServiceUsageRecord usageRecord = new ServiceUsageRecord();
        try {
            usageRecord.setConsumerId(TEST_CONSUMER_ID);
            usageRecord.setScope("/infrastructure/vo");
            usageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            usageRecord.setCallerHost(TEST_CALLER_HOST);
            usageRecord.setHost(TEST_HOST);
            usageRecord.setServiceClass(TEST_SERVICE_CLASS);
            usageRecord.setServiceName(TEST_SERVICE_NAME);
            usageRecord.setCalledMethod(TEST_CALLED_METHOD);
            usageRecord.setDuration(TestUsageRecord.generateRandomLong(60L, 1000L));
        }
        catch (InvalidValueException e) {
            logger.error(" ------ You SHOULD NOT SEE THIS MESSAGE. Error Creating a test Usage Record", e.getCause());
        }
        return usageRecord;
    }

    public static StorageUsageRecord createTestStorageUsageRecord() {
        StorageUsageRecord usageRecord = new StorageUsageRecord();
        try {
            usageRecord.setConsumerId(TEST_CONSUMER_ID);
            usageRecord.setScope("/infrastructure/vo");
            usageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            usageRecord.setResourceOwner(TEST_RESOUCE_OWNER);
            usageRecord.setResourceScope("/infrastructure/vo");
            usageRecord.setResourceURI(new URI(TEST_RESOURCE_URI));
            usageRecord.setProviderURI(new URI(TEST_PROVIDER_URI));
            usageRecord.setOperationType(StorageUsageRecord.OperationType.READ);
            usageRecord.setDataType(StorageUsageRecord.DataType.STORAGE);
            usageRecord.setDataVolume(TestUsageRecord.generateRandomLong(1024L, 10240L));
            usageRecord.setQualifier("image/png");
        }
        catch (URISyntaxException | InvalidValueException e) {
            logger.error(" ------ You SHOULD NOT SEE THIS MESSAGE. Error Creating a test Usage Record", e.getCause());
        }
        return usageRecord;
    }

    public static JobUsageRecord createTestJobUsageRecord() {
        JobUsageRecord usageRecord = new JobUsageRecord();
        try {
            usageRecord.setConsumerId(TEST_CONSUMER_ID);
            usageRecord.setScope("/infrastructure/vo");
            usageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
        }
        catch (InvalidValueException e) {
            logger.error(" ------ You SHOULD NOT SEE THIS MESSAGE. Error Creating a test Usage Record", e.getCause());
        }
        return usageRecord;
    }
}

