/**
 * 
 */
package org.gcube.accounting.datamodel.decorators;

import java.io.Serializable;

import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public interface FieldAction {

	/**
	 * Validate (and eventually convert) the value of the property identified by
	 * the key.
	 * @param key The key of the property
	 * @param value The value to be validated (and eventually converted) of the 
	 * property 
	 * @param usageRecord the Usage Record the property is attached 
	 * @return the validated (and eventually converted) value of the property
	 * @throws InvalidValueException if the validation or the eventual 
	 * conversion fails
	 */
	public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException;
	
}
