/**
 * 
 */
package org.gcube.accounting.datamodel.validations.validators;

import java.io.Serializable;

import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord.OperationType;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class FixDataVolumeSignAction implements FieldAction {
	
	protected Long checkIt(Long dataVolume, OperationType operationType){
		switch (operationType) {
			case CREATE:{
				dataVolume = (dataVolume > 0) ? dataVolume : -dataVolume; 
				break;
			}
			case READ:{
				dataVolume = (dataVolume > 0) ? dataVolume : -dataVolume;
				break;
			}
			case UPDATE:{
				break;
			}
			case DELETE:{
				dataVolume = (dataVolume < 0) ? dataVolume : -dataVolume; 
				break;
			}
			default:{
				break;
			}
		}
		
		return dataVolume;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException  {
		try {
			
			if(key.compareTo(AbstractStorageUsageRecord.DATA_VOLUME)==0){
				OperationType operationType = (OperationType) usageRecord.getResourceProperty(AbstractStorageUsageRecord.OPERATION_TYPE);
				if(operationType!=null){
					ValidLongValidator validLongValidator = new ValidLongValidator();
					value = validLongValidator.validate(key, value, usageRecord);
					Long dataVolume = new Long((Long) value);
					value = checkIt(dataVolume, operationType);
				}
			}
			
			if(key.compareTo(AbstractStorageUsageRecord.OPERATION_TYPE)==0){
				Long dataVolume = (Long) usageRecord.getResourceProperty(AbstractStorageUsageRecord.DATA_VOLUME);
				if(dataVolume!=null){
					ValidOperationTypeValidator v = new ValidOperationTypeValidator();
					value = v.validate(key, value, usageRecord);
					OperationType operationType = (OperationType) value;
					Long newDataVolume = checkIt(dataVolume, operationType);
					usageRecord.setResourceProperty(AbstractStorageUsageRecord.DATA_VOLUME, newDataVolume);
				}
			}
			
			
		}catch(InvalidValueException e){ }
		return value;
	}
}