/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregation.strategy;

import org.gcube.accounting.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.AggregationStrategy;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.exception.NotAggregatableRecordsExceptions;

public class ServiceUsageRecordAggregationStrategy
extends AggregationStrategy<AggregatedServiceUsageRecord, ServiceUsageRecord> {
    public ServiceUsageRecordAggregationStrategy(AggregatedServiceUsageRecord serviceUsageRecord) {
        super(serviceUsageRecord);
        this.aggregationField.add("callerHost");
        this.aggregationField.add("host");
        this.aggregationField.add("serviceClass");
        this.aggregationField.add("serviceName");
        this.aggregationField.add("calledMethod");
    }

    protected long durationWeightedAverage(AggregatedServiceUsageRecord record) {
        long tDuration = ((AggregatedServiceUsageRecord)this.t).getDuration() * (long)((AggregatedServiceUsageRecord)this.t).getOperationCount();
        long recordDuration = record.getDuration() * (long)record.getOperationCount();
        long totalOperationCount = ((AggregatedServiceUsageRecord)this.t).getOperationCount() + record.getOperationCount();
        return (tDuration + recordDuration) / totalOperationCount;
    }

    @Override
    protected AggregatedServiceUsageRecord reallyAggregate(AggregatedServiceUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            long min;
            ((AggregatedServiceUsageRecord)this.t).setDuration(this.durationWeightedAverage(record));
            ((AggregatedServiceUsageRecord)this.t).setOperationCount(((AggregatedServiceUsageRecord)this.t).getOperationCount() + record.getOperationCount());
            long max = record.getMaxInvocationTime();
            if (max > ((AggregatedServiceUsageRecord)this.t).getMaxInvocationTime()) {
                ((AggregatedServiceUsageRecord)this.t).setMaxInvocationTime(max);
            }
            if ((min = record.getMinInvocationTime()) < ((AggregatedServiceUsageRecord)this.t).getMinInvocationTime()) {
                ((AggregatedServiceUsageRecord)this.t).setMinInvocationTime(min);
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
        return (AggregatedServiceUsageRecord)this.t;
    }
}

