/**
 * 
 */
package org.gcube.accounting.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;

import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.decorators.AggregatedField;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * This Class is for library internal use only
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class AggregatedStorageUsageRecord extends AbstractStorageUsageRecord implements AggregatedUsageRecord<AggregatedStorageUsageRecord, StorageUsageRecord> {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 1082525518686785682L;
	
	// Redefining DATA_VOLUME to Set @AggregatedField
	@RequiredField @ValidLong @AggregatedField
	public static final String DATA_VOLUME = org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord.DATA_VOLUME;
		
	private void init(){
		this.resourceProperties.put(AGGREGATED, true);
	}
	
	public AggregatedStorageUsageRecord() {
		super();
		init();
	}
	
	public AggregatedStorageUsageRecord(Map<String, Serializable> properties) throws InvalidValueException{
		super(properties);
		init();
	}

	public AggregatedStorageUsageRecord(org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord record) throws InvalidValueException{
		super(record.getResourceProperties());
		this.setOperationCount(1);
		Calendar creationTime = record.getCreationTime();
		this.setCreationTime(Calendar.getInstance());
		this.setStartTime(creationTime);
		this.setEndTime(creationTime);
		init();
		
	}
	
	@Override
	public int getOperationCount() {
		return super.getOperationCount();
	}

	@Override
	public void setOperationCount(int operationCount) throws InvalidValueException {
		super.setOperationCount(operationCount);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public AggregatedStorageUsageRecord getAggregatedUsageRecord(StorageUsageRecord usageRecord)
			throws InvalidValueException {
		return new AggregatedStorageUsageRecord(usageRecord);
	}
	
}
