/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.basetypes;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.basetypes.CalculateWallDuration;
import org.gcube.accounting.datamodel.decorators.ComputedField;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.MoveToOperationResult;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.ValidInteger;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.exception.InvalidValueException;

public abstract class AbstractJobUsageRecord
extends BasicUsageRecord {
    private static final long serialVersionUID = -8648691183939346858L;
    @RequiredField
    @NotEmpty
    public static final String JOB_ID = "jobId";
    @RequiredField
    @NotEmpty
    public static final String JOB_QUALIFIER = "jobQualifier";
    @RequiredField
    @NotEmpty
    public static final String JOB_NAME = "jobName";
    @RequiredField
    @ValidLong
    @CalculateWallDuration
    public static final String JOB_START_TIME = "jobStartTime";
    @RequiredField
    @ValidLong
    @CalculateWallDuration
    public static final String JOB_END_TIME = "jobEndTime";
    @MoveToOperationResult
    @Deprecated
    protected static final String JOB_STATUS = "jobStatus";
    @ValidInteger
    public static final String VMS_USED = "vmsUsed";
    @ComputedField
    @ValidLong
    @CalculateWallDuration
    protected static final String WALL_DURATION = "wallDuration";
    private static final String ABSTRACT_TO_REPLACE = "Abstract";

    public AbstractJobUsageRecord() {
    }

    public AbstractJobUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    @Override
    protected String giveMeUsageRecordType() {
        return AbstractJobUsageRecord.class.getSimpleName().replace(ABSTRACT_TO_REPLACE, "");
    }

    public String getJobId() {
        return (String)this.resourceProperties.get(JOB_ID);
    }

    public void setJobId(String jobId) throws InvalidValueException {
        this.setResourceProperty(JOB_ID, (Serializable)((Object)jobId));
    }

    public String getJobQualifier() {
        return (String)this.resourceProperties.get(JOB_QUALIFIER);
    }

    public void setJobQualifier(String jobQualifier) throws InvalidValueException {
        this.setResourceProperty(JOB_QUALIFIER, (Serializable)((Object)jobQualifier));
    }

    public String getJobName() {
        return (String)this.resourceProperties.get(JOB_NAME);
    }

    public void setJobName(String jobName) throws InvalidValueException {
        this.setResourceProperty(JOB_NAME, (Serializable)((Object)jobName));
    }

    public Calendar getJobStartTime() {
        long millis = (Long)this.resourceProperties.get(JOB_START_TIME);
        return this.timestampStringToCalendar(millis);
    }

    public void setJobStartTime(Calendar jobStartTime) throws InvalidValueException {
        this.setResourceProperty(JOB_START_TIME, Long.valueOf(jobStartTime.getTimeInMillis()));
    }

    public Calendar getJobEndTime() {
        long millis = (Long)this.resourceProperties.get(JOB_END_TIME);
        return this.timestampStringToCalendar(millis);
    }

    public void setJobEndTime(Calendar jobEndTime) throws InvalidValueException {
        this.setResourceProperty(JOB_END_TIME, Long.valueOf(jobEndTime.getTimeInMillis()));
    }

    public int getVmsUsed() {
        return (Integer)this.resourceProperties.get(VMS_USED);
    }

    public void setVmsUsed(int vmsUsed) throws InvalidValueException {
        this.setResourceProperty(VMS_USED, Integer.valueOf(vmsUsed));
    }

    protected long calculateWallDuration() throws InvalidValueException {
        try {
            long endTime = (Long)this.resourceProperties.get(JOB_END_TIME);
            long startTime = (Long)this.resourceProperties.get(JOB_START_TIME);
            long wallDuration = endTime - startTime;
            return wallDuration;
        }
        catch (Exception e) {
            throw new InvalidValueException(String.format("To calculate Wall Duration both %s and %s must be set", "startTime", "endTime"), e);
        }
    }

    public long getWallDuration() throws InvalidValueException {
        Long wallDuration = (Long)this.resourceProperties.get(WALL_DURATION);
        if (wallDuration == null) {
            wallDuration = this.calculateWallDuration();
        }
        return wallDuration;
    }

    protected static enum JobStatus {
        completed,
        failed;

    }
}

