/**
 * 
 */
package org.gcube.accounting.datamodel.basetypes;

import java.io.Serializable;

import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.implementation.FieldAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateWallDurationAction implements FieldAction {
	
	private static final Logger logger = LoggerFactory.getLogger(CalculateWallDurationAction.class);
	
	@Override
	public Comparable<? extends Serializable> validate(String key, Comparable<? extends Serializable> value, Record record) throws InvalidValueException  {
		try {
			long wallDuration = ((AbstractJobUsageRecord) record).calculateWallDuration();
			if(key.compareTo(AbstractJobUsageRecord.WALL_DURATION)==0){
				logger.warn("{} is automatically computed using {} and {}. This invocation has the only effect of recalculating the value. Any provided value is ignored.", 
						AbstractJobUsageRecord.WALL_DURATION, AbstractJobUsageRecord.JOB_START_TIME, AbstractJobUsageRecord.JOB_END_TIME);
				value = wallDuration;
			}
		}catch(InvalidValueException e){ }
		return value;
	}
}