/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedSet;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.backwardcompatibility.MoveToRecordType;
import org.gcube.accounting.datamodel.validations.annotations.ValidOperationResult;
import org.gcube.accounting.datamodel.validations.validators.ValidOperationResultValidator;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.implementation.AbstractRecord;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="UsageRecord")
public class BasicUsageRecord
extends AbstractRecord
implements UsageRecord {
    private static final long serialVersionUID = -2060728578456796388L;
    private static Logger logger = LoggerFactory.getLogger(BasicUsageRecord.class);
    @Deprecated
    @MoveToRecordType
    public static final String USAGE_RECORD_TYPE = "usageRecordType";
    @RequiredField
    @NotEmpty
    public static final String CONSUMER_ID = "consumerId";
    @RequiredField
    @NotEmpty
    public static final String SCOPE = "scope";
    @RequiredField
    @ValidOperationResult
    public static final String OPERATION_RESULT = "operationResult";

    public static String getScopeFromToken() {
        String scope = ScopeProvider.instance.get();
        if (scope == null) {
            AuthorizationEntry authorizationEntry;
            String token = SecurityTokenProvider.instance.get();
            try {
                authorizationEntry = Constants.authorizationService().get(token);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            scope = authorizationEntry.getContext();
        }
        return scope;
    }

    protected void init() {
        super.init();
        try {
            this.setScope(BasicUsageRecord.getScopeFromToken());
        }
        catch (Exception e) {
            logger.warn("Unable to automaticcally set the scope using scope provider. The record will not be valid if the scope will not be explicitly set.");
        }
    }

    public BasicUsageRecord() {
    }

    public BasicUsageRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public SortedSet<String> getQuerableKeys() throws Exception {
        SortedSet properties = super.getQuerableKeys();
        properties.remove(SCOPE);
        return properties;
    }

    @Override
    @JsonIgnore
    public String getConsumerId() {
        return (String)this.resourceProperties.get(CONSUMER_ID);
    }

    @Override
    @JsonIgnore
    public void setConsumerId(String consumerId) throws InvalidValueException {
        this.setResourceProperty(CONSUMER_ID, (Serializable)((Object)consumerId));
    }

    @JsonIgnore
    protected String giveMeRecordType() {
        return BasicUsageRecord.class.getSimpleName();
    }

    @Override
    @JsonIgnore
    public String getScope() {
        return (String)this.resourceProperties.get(SCOPE);
    }

    @Override
    @JsonIgnore
    public void setScope(String scope) throws InvalidValueException {
        this.setResourceProperty(SCOPE, (Serializable)((Object)scope));
    }

    @Override
    @JsonIgnore
    public UsageRecord.OperationResult getOperationResult() {
        try {
            return (UsageRecord.OperationResult)new ValidOperationResultValidator().validate(OPERATION_RESULT, (Serializable)this.resourceProperties.get(OPERATION_RESULT), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @JsonIgnore
    public void setOperationResult(UsageRecord.OperationResult operationResult) throws InvalidValueException {
        this.setResourceProperty(OPERATION_RESULT, operationResult);
    }
}

