/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.aggregation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractJobUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.JobUsageRecord;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.aggregation.AggregationUtility;

@JsonTypeName(value="JobUsageRecord")
public class AggregatedJobUsageRecord
extends AbstractJobUsageRecord
implements AggregatedUsageRecord<AggregatedJobUsageRecord, JobUsageRecord> {
    private static final long serialVersionUID = -3376423316219914682L;

    public AggregatedJobUsageRecord() {
    }

    public AggregatedJobUsageRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public AggregatedJobUsageRecord(JobUsageRecord record) throws InvalidValueException {
        super(record.getResourceProperties());
        this.setOperationCount(1);
        Calendar creationTime = record.getCreationTime();
        this.setCreationTime(Calendar.getInstance());
        this.setStartTime(creationTime);
        this.setEndTime(creationTime);
    }

    @JsonIgnore
    public int getOperationCount() {
        return super.getOperationCount();
    }

    @JsonIgnore
    public void setOperationCount(int operationCount) throws InvalidValueException {
        super.setOperationCount(operationCount);
    }

    @JsonIgnore
    public Calendar getStartTime() {
        return super.getStartTimeAsCalendar();
    }

    @JsonIgnore
    public void setStartTime(Calendar startTime) throws InvalidValueException {
        super.setStartTime(startTime);
    }

    @JsonIgnore
    public Calendar getEndTime() {
        return super.getEndTimeAsCalendar();
    }

    @JsonIgnore
    public void setEndTime(Calendar endTime) throws InvalidValueException {
        super.setEndTime(endTime);
    }

    @JsonIgnore
    public void setAggregate(Boolean aggregate) throws InvalidValueException {
        super.setAggregate(aggregate);
    }

    @JsonIgnore
    public Boolean getAggregate() {
        return super.getAggregate();
    }

    @JsonIgnore
    public AggregatedJobUsageRecord aggregate(AggregatedJobUsageRecord record) throws NotAggregatableRecordsExceptions {
        throw new NotAggregatableRecordsExceptions();
    }

    @JsonIgnore
    public AggregatedJobUsageRecord aggregate(JobUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.aggregate(new AggregatedJobUsageRecord(record));
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions((Throwable)ex);
        }
    }

    public boolean isAggregable(AggregatedJobUsageRecord record) throws NotAggregatableRecordsExceptions {
        AggregationUtility aggregationUtility = new AggregationUtility((AggregatedRecord)this);
        return aggregationUtility.isAggregable((AggregatedRecord)record);
    }

    public boolean isAggregable(JobUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.isAggregable(new AggregatedJobUsageRecord(record));
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions((Throwable)ex);
        }
    }

    @JsonIgnore
    public Class<JobUsageRecord> getAggregable() {
        return JobUsageRecord.class;
    }

    protected void cleanExtraFields() {
    }
}

