/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.basetypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.validations.annotations.FixDataVolumeSign;
import org.gcube.accounting.datamodel.validations.annotations.ValidDataTypeVolume;
import org.gcube.accounting.datamodel.validations.annotations.ValidURI;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.NotEmpty;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;

public abstract class AbstractStorageStatusRecord
extends BasicUsageRecord {
    private static final long serialVersionUID = -5754343539116896036L;
    @RequiredField
    @ValidLong
    @FixDataVolumeSign
    public static final String DATA_VOLUME = "dataVolume";
    @RequiredField
    @ValidDataTypeVolume
    public static final String DATA_TYPE = "dataType";
    @RequiredField
    @NotEmpty
    public static final String DATA_COUNT = "dataCount";
    @RequiredField
    @NotEmpty
    public static final String DATA_SERVICECLASS = "dataServiceClass";
    @RequiredField
    @NotEmpty
    public static final String DATA_SERVICENAME = "dataServiceName";
    @RequiredField
    @NotEmpty
    public static final String DATA_SERVICEID = "dataServiceId";
    @RequiredField
    @ValidURI
    public static final String PROVIDER_ID = "providerId";
    private static final String ABSTRACT_TO_REPLACE = "Abstract";

    public AbstractStorageStatusRecord() {
    }

    public AbstractStorageStatusRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    @Override
    public String getRecordType() {
        return AbstractStorageStatusRecord.class.getSimpleName().replace(ABSTRACT_TO_REPLACE, "");
    }

    @JsonIgnore
    public long getDataVolume() {
        return (Long)this.resourceProperties.get(DATA_VOLUME);
    }

    public void setDataVolume(long dataVolume) throws InvalidValueException {
        this.setResourceProperty(DATA_VOLUME, Long.valueOf(dataVolume));
    }

    @JsonIgnore
    public DataType getDataType() {
        return (DataType)((Object)this.resourceProperties.get(DATA_TYPE));
    }

    public void setDataType(DataType dataType) throws InvalidValueException {
        this.setResourceProperty(DATA_TYPE, (Serializable)((Object)dataType));
    }

    @JsonIgnore
    public long getDataCount() {
        return (Long)this.resourceProperties.get(DATA_COUNT);
    }

    public void setDataCount(long dataCount) throws InvalidValueException {
        this.setResourceProperty(DATA_COUNT, Long.valueOf(dataCount));
    }

    @JsonIgnore
    public String getDataServiceClass() {
        return (String)this.resourceProperties.get(DATA_SERVICECLASS);
    }

    public void setDataServiceClass(String dataServiceClass) throws InvalidValueException {
        this.setResourceProperty(DATA_SERVICECLASS, (Serializable)((Object)dataServiceClass));
    }

    @JsonIgnore
    public String getDataServiceName() {
        return (String)this.resourceProperties.get(DATA_SERVICENAME);
    }

    public void setDataServiceName(String dataServiceName) throws InvalidValueException {
        this.setResourceProperty(DATA_SERVICENAME, (Serializable)((Object)dataServiceName));
    }

    @JsonIgnore
    public String getDataServiceId() {
        return (String)this.resourceProperties.get(DATA_SERVICEID);
    }

    public void setDataServiceId(String dataServiceId) throws InvalidValueException {
        this.setResourceProperty(DATA_SERVICEID, (Serializable)((Object)dataServiceId));
    }

    @JsonIgnore
    public URI getProviderId() {
        return (URI)this.resourceProperties.get(PROVIDER_ID);
    }

    public void setProviderId(URI provideId) throws InvalidValueException {
        this.setResourceProperty(PROVIDER_ID, provideId);
    }

    public static enum DataType {
        STORAGE,
        TREE,
        GEO,
        DATABASE,
        LOCAL,
        OTHER;

    }
}

