/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.service;

import java.util.Set;
import org.gcube.accounting.aggregator.RegexRulesAggregator;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.common.security.factories.AuthorizationProvider;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingManager
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(AccountingManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onInit() {
        AuthorizationProvider authorizationProvider = ProviderFactory.provider().containerContext().authorizationProvider();
        Set contexts = authorizationProvider.getContexts();
        logger.trace("-------------------------------------------------------\nAccouting Service is Starting in contexts {}\n-------------------------------------------------------", (Object)contexts);
        try {
            for (String context : contexts) {
                try {
                    Secret secret = authorizationProvider.getSecretForContext(context);
                    SecretManagerProvider.set((Secret)secret);
                    AccountingPersistenceFactory.getPersistence();
                    RegexRulesAggregator.getInstance();
                    logger.trace("---------------------------------------------------\n\tAccounting Service successfully initialized\n---------------------------------------------------");
                    return;
                }
                catch (Exception e) {
                    try {
                        logger.error("Error while initializing Accounting Service using context {}. Trying another one", (Object)context, (Object)e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            SecretManagerProvider.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onShutdown() {
        AuthorizationProvider authorizationProvider = ProviderFactory.provider().containerContext().authorizationProvider();
        Set contexts = authorizationProvider.getContexts();
        logger.trace("--------------------------------------\n\tAccounting Service is Stopping\n--------------------------------------");
        try {
            for (String context : contexts) {
                try {
                    AccountingPersistenceFactory.getPersistence().close();
                    RegexRulesAggregator.getInstance().stop();
                    logger.trace("---------------------------------------------\n\tAccounting Service gracefully stopped\n---------------------------------------------");
                    return;
                }
                catch (Exception e) {
                    try {
                        logger.error("Error while stopping Accounting Service in context {}. Trying another one", (Object)context, (Object)e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            SecretManagerProvider.reset();
        }
    }
}

