

package org.gcube.accounting.usagetracker.rest.resources.raw;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.usagetracker.rest.resources.AbstractRecordsResource;

@Path("/usagerecords")
public class RawRecordsResource extends AbstractRecordsResource<RawUsageRecord> {

	private static Logger logger = Logger.getLogger(RawRecordsResource.class);
	
	public RawUsageRecord createRecord(RawUsageRecord record) {
		return record;
	}

	@Path("{usagerecord}")
	public RawRecordResource getRecordResource(
			@PathParam("usagerecord") String record_id) {
		RawRecordResource out = new RawRecordResource(record_id);
		out.setUserId((String)request.getAttribute("userId"));
		return out;
	}

//	@DELETE
//	private void delete() {
//		try {
//			UsageTrackerDB db = UsageTrackerDB.getStorage();
//			db.clear();
//		} catch (Exception e) {
//			e.printStackTrace();
//			throw new ServerErrorException();
//		}
//	}

	protected void validate(RawUsageRecord record) throws InvalidValueException {
		String resourceType = record.getResourceType();
		logger.debug("resource type is " + resourceType);
		if(record.getCreateTime() == null)
			throw new InvalidValueException("cannot upload records without a valid CREATE_TIME field");
//		if(resourceType.equals(VMUsageRecord.TYPE_VM))
//			throw new InvalidValueException("cannot upload "+resourceType+" records through the generic path");
//		if(resourceType.equals(NetworkUsageRecord.TYPE_NETWORK))
//			throw new InvalidValueException("cannot upload "+resourceType+" records through the generic path");
//		if(resourceType.equals(JobUsageRecord.TYPE_JOB))
//			throw new InvalidValueException("cannot upload "+resourceType+" records through the generic path");
//		if(resourceType.equals(StorageRecord.STORAGE))
//			throw new InvalidValueException("cannot upload "+resourceType+" records through the generic path");
		//record.validate();
	}
	
}
