/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources.filters;

import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.FilterRating;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

@Path(value="/filters/storage-status/")
public class StorageStatusFilters {
    private static Logger logger = Logger.getLogger(StorageStatusFilters.class);
    @Context
    protected HttpServletRequest request;

    @POST
    @Path(value="avg-volume")
    @Produces(value={"application/xml"})
    public FilterRating getAvgVolumeFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getStorageStatusAvgVolumeFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="avg-entities")
    @Produces(value={"application/xml"})
    public FilterRating getAvgEntitiesFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getStorageStatusAvgEntitiesFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="volume")
    @Produces(value={"application/xml"})
    public FilterRating getVolumeFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getStorageStatusVolumeFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="entities")
    @Produces(value={"application/xml"})
    public FilterRating getEntitiesFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getStorageStatusEntitiesFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }
}

