/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.persistence;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.gcube.accounting.common.helper.ISClientConnector;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.adapter.EntryFilterRating;
import org.gcube.accounting.datamodel.aggregation.AggregationField;
import org.gcube.accounting.datamodel.aggregation.ResultOptions;
import org.gcube.accounting.datamodel.query.QueryClause;
import org.gcube.accounting.datamodel.query.QueryOperator;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.AggregatedResult;
import org.gcube.accounting.datamodel.reports.aggregation.FilterRating;
import org.gcube.accounting.datamodel.reports.aggregation.Metric;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.exception.NotFoundException;
import org.gcube.accounting.usagetracker.configuration.Configuration;
import org.gcube.accounting.usagetracker.persistence.DBCollections;
import org.gcube.accounting.usagetracker.persistence.DBField;
import org.gcube.accounting.usagetracker.persistence.EnhancedQuery;
import org.gcube.accounting.usagetracker.persistence.MongoAggregationHelper;
import org.gcube.accounting.usagetracker.persistence.Record;
import org.gcube.accounting.usagetracker.persistence.ResultSet;
import org.joda.time.DateTime;

/*
 * Exception performing whole class analysis ignored.
 */
public class UsageTrackerDB {
    private static final String RSP_PREFIX = "rsp:";
    private static final String DOLLAR = "\\\\DOL";
    private static final String DOT = "\\\\DOT";
    private static final String BACKSLASH = "\\\\\\\\";
    private static UsageTrackerDB utdb;
    private MongoClient mongo;
    private DB db;
    private static DBField[] baseFields;
    private static Logger logger;

    private UsageTrackerDB(String hostname, String dbname, int port) throws UnknownHostException {
        this.mongo = new MongoClient(hostname, port);
        this.db = this.mongo.getDB(dbname);
        this.ensureIndexesForUsageRecords(this.getUsageRecordsCollection());
    }

    private UsageTrackerDB(String hostname, String dbname, int port, String username, String password) throws UnknownHostException {
        this(hostname, dbname, port);
        this.db.authenticate(username, password.toCharArray());
    }

    private boolean isBaseField(String field) {
        for (DBField f : baseFields) {
            if (!f.toString().equals(field)) continue;
            return true;
        }
        return false;
    }

    public static UsageTrackerDB getStorage() throws UnknownHostException {
        if (utdb == null) {
            Configuration conf = Configuration.getInstance();
            if (conf.isRemoteDBEnabled().booleanValue()) {
                ISClientConnector gCubeISClient = new ISClientConnector();
                String[] stringArray = gCubeISClient.getServerRRFws();
            } else {
                utdb = conf.isDBAuthnEnabled() != false ? new UsageTrackerDB(conf.getDBHost(), conf.getDBName(), conf.getDBPort(), conf.getDBUser(), conf.getDBPassword()) : new UsageTrackerDB(conf.getDBHost(), conf.getDBName(), conf.getDBPort());
            }
        }
        return utdb;
    }

    private DBObject createDBObject(UsageRecord ur) {
        BasicDBObject doc = new BasicDBObject();
        doc.put(DBField.UR_ID.toString(), (Object)ur.getId());
        if (ur.getCreateTime() != null) {
            doc.put(DBField.CREATE_TIME.toString(), (Object)ur.getCreateTime());
        }
        doc.put(DBField.CREATOR_ID.toString(), (Object)ur.getCreatorId());
        doc.put(DBField.CONSUMER_ID.toString(), (Object)ur.getConsumerId());
        doc.put(DBField.FULLY_QUALIFIED_CONSUMER_ID.toString(), (Object)ur.getFullyQualifiedConsumerId());
        doc.put(DBField.RESOURCE_TYPE.toString(), (Object)ur.getResourceType());
        doc.put(DBField.RESOURCE_OWNER.toString(), (Object)ur.getResourceOwner());
        doc.put(DBField.RESOURCE_SCOPE.toString(), (Object)ur.getResourceScope());
        if (ur.getStartTime() != null) {
            logger.debug((Object)("createDBObject.startTime = " + ur.getStartTime()));
            doc.put(DBField.START_TIME.toString(), (Object)ur.getStartTime());
        }
        if (ur.getEndTime() != null) {
            doc.put(DBField.END_TIME.toString(), (Object)ur.getEndTime());
        }
        Map properties = ur.getResourceSpecificProperties();
        for (String key : properties.keySet()) {
            if (doc.keySet().contains(key)) continue;
            try {
                Double value = Double.parseDouble((String)properties.get(key));
                doc.put("rsp:" + this.encodeKey(key), (Object)value);
            }
            catch (NumberFormatException e) {
                try {
                    Long value = Long.parseLong((String)properties.get(key));
                    doc.put("rsp:" + this.encodeKey(key), (Object)value);
                }
                catch (NumberFormatException e2) {
                    doc.put("rsp:" + this.encodeKey(key), properties.get(key));
                }
                doc.put("rsp:" + this.encodeKey(key), properties.get(key));
            }
        }
        return doc;
    }

    private RawUsageRecord createUsageRecord(DBObject dbo) {
        RawUsageRecord out = new RawUsageRecord();
        out.setId((String)dbo.get(DBField.UR_ID.toString()));
        out.setConsumerId((String)dbo.get(DBField.CONSUMER_ID.toString()));
        out.setFullyQualifiedConsumerId((String)dbo.get(DBField.FULLY_QUALIFIED_CONSUMER_ID.toString()));
        out.setCreatorId((String)dbo.get(DBField.CREATOR_ID.toString()));
        out.setResourceType((String)dbo.get(DBField.RESOURCE_TYPE.toString()));
        out.setResourceOwner((String)dbo.get(DBField.RESOURCE_OWNER.toString()));
        out.setResourceScope((String)dbo.get(DBField.RESOURCE_SCOPE.toString()));
        if (dbo.get(DBField.START_TIME.toString()) != null) {
            try {
                out.setStartTime((Date)dbo.get(DBField.START_TIME.toString()));
            }
            catch (InvalidValueException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (dbo.get(DBField.END_TIME.toString()) != null) {
            try {
                out.setEndTime((Date)dbo.get(DBField.END_TIME.toString()));
            }
            catch (InvalidValueException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (dbo.get(DBField.CREATE_TIME.toString()) != null) {
            // empty if block
        }
        for (String key : dbo.keySet()) {
            Object value;
            if (this.isBaseField(key) || !((value = dbo.get(key)) instanceof String) && !(value instanceof Double) && !(value instanceof Long) || !key.startsWith("rsp:")) continue;
            out.setResourceSpecificProperty(this.decodeKey(key), dbo.get(key).toString());
        }
        return out;
    }

    public void addUsageRecord(UsageRecord ur) {
        ur.setCreateTime(new Date());
        DBCollection coll = this.getUsageRecordsCollection();
        logger.info((Object)String.format("inserting new record %s", ur.getId()));
        coll.insert(new DBObject[]{this.createDBObject(ur)});
        logger.info((Object)"Updating support collections...");
        this.updateSupportCollections(ur);
        this.addConsumerGroup(ur.getFullyQualifiedConsumerId());
    }

    private void updateSupportCollections(UsageRecord ur) {
        BasicDBObject resourceScope;
        DBCollection collResourceScopes;
        DBCursor cursorResourceScope;
        BasicDBObject resourceType;
        DBCollection collResourceTypes = this.getResourceTypesCollection();
        DBCursor cursorResourceType = collResourceTypes.find((DBObject)(resourceType = new BasicDBObject(DBField.RESOURCE_TYPE.toString(), (Object)ur.getResourceType())));
        if (!cursorResourceType.hasNext()) {
            collResourceTypes.insert(new DBObject[]{resourceType});
        }
        if (!(cursorResourceScope = (collResourceScopes = this.getResourceScopesCollection()).find((DBObject)(resourceScope = new BasicDBObject(DBField.RESOURCE_SCOPE.toString(), (Object)ur.getResourceScope())))).hasNext()) {
            collResourceScopes.insert(new DBObject[]{resourceScope});
        }
    }

    private void updateStatistics(UsageRecord ur) {
        BasicDBObject resourceScope;
        DBCollection collResourceScopes;
        DBCursor cursorResourceScope;
        BasicDBObject resourceType;
        DBCollection collResourceTypes = this.getResourceTypesCollection();
        DBCursor cursorResourceType = collResourceTypes.find((DBObject)(resourceType = new BasicDBObject(DBField.RESOURCE_TYPE.toString(), (Object)ur.getResourceType())));
        if (!cursorResourceType.hasNext()) {
            collResourceTypes.insert(new DBObject[]{resourceType});
        }
        if (!(cursorResourceScope = (collResourceScopes = this.getResourceScopesCollection()).find((DBObject)(resourceScope = new BasicDBObject(DBField.RESOURCE_SCOPE.toString(), (Object)ur.getResourceScope())))).hasNext()) {
            collResourceScopes.insert(new DBObject[]{resourceScope});
        }
    }

    private DBCollection ensureIndexesForUsageRecords(DBCollection usageRecordsCollection) {
        usageRecordsCollection.ensureIndex((DBObject)new BasicDBObject(DBField.UR_ID.toString(), (Object)1).append("unique", (Object)true).append("dropDups", (Object)true));
        usageRecordsCollection.ensureIndex((DBObject)new BasicDBObject(DBField.FULLY_QUALIFIED_CONSUMER_ID.toString(), (Object)1));
        usageRecordsCollection.ensureIndex((DBObject)new BasicDBObject(DBField.CONSUMER_ID.toString(), (Object)1));
        usageRecordsCollection.ensureIndex((DBObject)new BasicDBObject(DBField.END_TIME.toString(), (Object)1));
        usageRecordsCollection.ensureIndex((DBObject)new BasicDBObject(DBField.START_TIME.toString(), (Object)1));
        usageRecordsCollection.ensureIndex((DBObject)new BasicDBObject(DBField.CREATE_TIME.toString(), (Object)1));
        usageRecordsCollection.ensureIndex((DBObject)new BasicDBObject(DBField.RESOURCE_OWNER.toString(), (Object)1));
        usageRecordsCollection.ensureIndex((DBObject)new BasicDBObject(DBField.RESOURCE_SCOPE.toString(), (Object)1));
        usageRecordsCollection.ensureIndex((DBObject)new BasicDBObject(DBField.RESOURCE_TYPE.toString(), (Object)1));
        return usageRecordsCollection;
    }

    private DBCollection getUsageRecordsCollection() {
        DBCollection coll = this.db.getCollection(DBCollections.USAGE_RECORDS.toString());
        logger.debug((Object)"enforcing indexes");
        return this.ensureIndexesForUsageRecords(coll);
    }

    private DBCollection getResourceTypesCollection() {
        DBCollection coll = this.db.getCollection(DBCollections.RESOURCE_TYPES.toString());
        logger.debug((Object)"enforcing indexes");
        return coll;
    }

    private DBCollection getResourceScopesCollection() {
        DBCollection coll = this.db.getCollection(DBCollections.RESOURCE_SCOPES.toString());
        logger.debug((Object)"enforcing indexes");
        return coll;
    }

    private DBCollection getStatisticsCollection() {
        DBCollection coll = this.db.getCollection(DBCollections.RESOURCE_TYPES.toString());
        logger.debug((Object)"enforcing indexes");
        return coll;
    }

    public void updateUsageRecord(UsageRecord ur) {
        DBCollection coll = this.getUsageRecordsCollection();
        try {
            UsageRecord oldUR = this.getUsageRecord(ur.getId());
            ur.setCreateTime(oldUR.getCreateTime());
            DBObject newUR = this.createDBObject(ur);
            logger.info((Object)String.format("updating record %s", ur.getId()));
            coll.update((DBObject)new BasicDBObject().append("urId", (Object)ur.getId()), newUR);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    private BasicDBObject getDBObject(String key, String op, String value) {
        try {
            Long d = Long.parseLong(value);
            return new BasicDBObject(op, (Object)d);
        }
        catch (NumberFormatException e) {
            try {
                Double d = Double.parseDouble(value);
                return new BasicDBObject(op, (Object)d);
            }
            catch (NumberFormatException e2) {
                return new BasicDBObject(op, (Object)value);
            }
        }
    }

    private EnhancedQuery generateQuery(Map<String, QueryClause> props) {
        BasicDBObject query = new BasicDBObject();
        ResultOptions options = new ResultOptions(DBField.END_TIME.toString());
        logger.debug((Object)"after enhanced query preliminary options setting");
        for (QueryClause clause : props.values()) {
            logger.debug((Object)("adding " + clause.getKey() + ":" + clause.getValue()));
            if (QueryOperator.eq.equals((Object)clause.getOperator())) {
                if (clause.getKey().equals(AggregationField.SORT_FIELD.toString())) {
                    logger.debug((Object)("generating query with sortField = " + clause.getValue()));
                    options.setSortField(clause.getValue());
                    continue;
                }
                if (clause.getKey().equals(AggregationField.SORT_ORDER.toString())) {
                    options.setSortOrder(clause.getValue());
                    continue;
                }
                if (clause.getKey().equals(AggregationField.PAGINATION_START_RECORD.toString())) {
                    options.setStartRecord(Integer.valueOf(clause.getValue()).intValue());
                    continue;
                }
                if (clause.getKey().equals(AggregationField.PAGINATION_RECORDS.toString())) {
                    options.setRecordsPerPage(Integer.valueOf(clause.getValue()).intValue());
                    continue;
                }
                if (clause.getKey().equals("startTime")) {
                    StringTokenizer st = new StringTokenizer(clause.getValue(), ",");
                    String from = st.nextToken();
                    String to = st.nextToken();
                    logger.debug((Object)("from = " + from));
                    logger.debug((Object)("to = " + to));
                    BasicDBObject date = new BasicDBObject();
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    Date fromDate = null;
                    Date toDate = null;
                    try {
                        fromDate = df.parse(from);
                        toDate = df.parse(to);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    date.append("$gte", (Object)fromDate);
                    date.append("$lte", (Object)toDate);
                    query.put(clause.getKey(), (Object)date);
                    logger.debug((Object)("query = " + query.toMap()));
                    continue;
                }
                if (clause.getKey().equals(DBField.FULLY_QUALIFIED_CONSUMER_ID.toString())) {
                    String pattern = "^" + clause.getValue().replace(".", "\\.");
                    Pattern match = Pattern.compile(pattern);
                    query.put(clause.getKey(), (Object)match);
                    continue;
                }
                if (clause.getValue().contains(",")) {
                    ArrayList<String> listValues = new ArrayList<String>();
                    StringTokenizer stMultipleValues = new StringTokenizer(clause.getValue(), ",");
                    while (stMultipleValues.hasMoreTokens()) {
                        String kvMultipleValues = stMultipleValues.nextToken();
                        listValues.add(kvMultipleValues);
                    }
                    query.put(clause.getKey(), (Object)new BasicDBObject("$in", listValues));
                    continue;
                }
                try {
                    Long d = Long.parseLong(clause.getValue());
                    logger.debug((Object)("Long ------" + clause.getKey() + ", " + clause.getValue()));
                    query.put(clause.getKey(), (Object)d);
                }
                catch (NumberFormatException e) {
                    try {
                        Double d = Double.parseDouble(clause.getValue());
                        logger.debug((Object)("Double ------" + clause.getKey() + ", " + clause.getValue()));
                        query.put(clause.getKey(), (Object)d);
                    }
                    catch (NumberFormatException e2) {
                        query.put(clause.getKey(), (Object)clause.getValue());
                    }
                }
                continue;
            }
            if (QueryOperator.lt.equals((Object)clause.getOperator())) {
                query.put(clause.getKey(), (Object)this.getDBObject(clause.getKey(), "$lt", clause.getValue()));
                continue;
            }
            if (QueryOperator.lte.equals((Object)clause.getOperator())) {
                query.put(clause.getKey(), (Object)this.getDBObject(clause.getKey(), "$lte", clause.getValue()));
                continue;
            }
            if (QueryOperator.gt.equals((Object)clause.getOperator())) {
                query.put(clause.getKey(), (Object)this.getDBObject(clause.getKey(), "$gt", clause.getValue()));
                continue;
            }
            if (QueryOperator.gte.equals((Object)clause.getOperator())) {
                query.put(clause.getKey(), (Object)this.getDBObject(clause.getKey(), "$gte", clause.getValue()));
                continue;
            }
            logger.warn((Object)("operator '" + clause.getOperator() + "' is not yet supported"));
        }
        return new EnhancedQuery(query, options);
    }

    public long size() {
        return this.getUsageRecordsCollection().count();
    }

    public long size(Map<String, QueryClause> props) {
        EnhancedQuery query = this.generateQuery(props);
        return this.getUsageRecordsCollection().find((DBObject)query.getQuery()).count();
    }

    public Collection<RawUsageRecord> getUsageRecordByQuery(Map<String, QueryClause> props) {
        Vector<RawUsageRecord> out = new Vector<RawUsageRecord>();
        DBCollection coll = null;
        DBCursor cursor = null;
        coll = this.db.getCollection(DBCollections.USAGE_RECORDS.toString());
        logger.debug((Object)"Befor enhanced query");
        EnhancedQuery enhancedQuery = this.generateQuery(props);
        BasicDBObject sortCriteria = new BasicDBObject(enhancedQuery.getOptions().getSortField(), (Object)enhancedQuery.getOptions().getSortOrder());
        logger.debug((Object)("sortCriteria = " + enhancedQuery.getOptions().getSortField() + " , " + enhancedQuery.getOptions().getSortOrder()));
        logger.debug((Object)("** enhancedQuery = " + enhancedQuery.getQuery()));
        cursor = coll.find((DBObject)enhancedQuery.getQuery()).sort((DBObject)sortCriteria).skip(enhancedQuery.getOptions().getStartRecord()).limit(enhancedQuery.getOptions().getRecordsPerPage());
        logger.debug((Object)("found " + cursor.size() + " records"));
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            out.add(this.createUsageRecord(dbo));
        }
        return out;
    }

    public UsageRecord getUsageRecord(String id) throws NotFoundException {
        BasicDBObject query = new BasicDBObject();
        query.put(DBField.UR_ID.toString(), (Object)id);
        DBCollection coll = this.db.getCollection(DBCollections.USAGE_RECORDS.toString());
        DBCursor cur = coll.find((DBObject)query);
        if (cur.hasNext()) {
            DBObject out = cur.next();
            return this.createUsageRecord(out);
        }
        throw new NotFoundException("id");
    }

    public void deleteUsageRecord(String id) {
        logger.info((Object)String.format("deleting usage record '%s' ...", id));
        BasicDBObject query = new BasicDBObject();
        query.put(DBField.UR_ID.toString(), (Object)id);
        DBCollection coll = this.db.getCollection(DBCollections.USAGE_RECORDS.toString());
        coll.remove((DBObject)query, WriteConcern.SAFE);
    }

    public void clear() {
        this.getTrackedUsers();
        DBCollection coll = this.db.getCollection(DBCollections.USAGE_RECORDS.toString());
        BasicDBObject query = new BasicDBObject();
        coll.remove((DBObject)query, WriteConcern.SAFE);
        coll = this.db.getCollection(DBCollections.CONSUMERS_RECORDS.toString());
        query = new BasicDBObject();
        coll.remove((DBObject)query, WriteConcern.SAFE);
    }

    public Collection<RawUsageRecord> getAll() {
        Vector<RawUsageRecord> out = new Vector<RawUsageRecord>();
        DBCollection coll = this.db.getCollection(DBCollections.USAGE_RECORDS.toString());
        BasicDBObject query = new BasicDBObject();
        DBCursor cur = coll.find((DBObject)query);
        while (cur.hasNext()) {
            DBObject dbo = cur.next();
            out.add(this.createUsageRecord(dbo));
        }
        return out;
    }

    public Collection<String> getTrackedUsers() {
        return this.getDistinct(DBField.CONSUMER_ID.toString());
    }

    public Collection<String> getTrackedResourceTypes() {
        Vector<String> out = new Vector<String>();
        DBCollection coll = this.getResourceTypesCollection();
        DBCursor items = coll.find();
        while (items.hasNext()) {
            DBObject dbo = items.next();
            out.add((String)dbo.get(DBField.RESOURCE_TYPE.toString()));
        }
        return out;
    }

    public Collection<String> getTrackedResourceScopes() {
        Vector<String> out = new Vector<String>();
        DBCollection coll = this.getResourceScopesCollection();
        DBCursor items = coll.find();
        while (items.hasNext()) {
            DBObject dbo = items.next();
            out.add((String)dbo.get(DBField.RESOURCE_SCOPE.toString()));
        }
        return out;
    }

    public Collection<String> getTrackedResourceOwners() {
        return this.getDistinct(DBField.RESOURCE_OWNER.toString());
    }

    public Collection<String> getTrackedGroups() {
        return this.getDistinct(DBField.FULLY_QUALIFIED_CONSUMER_ID.toString());
    }

    private Collection<String> getDistinct(String key) {
        Vector<String> out = new Vector<String>();
        DBCollection coll = this.db.getCollection(DBCollections.USAGE_RECORDS.toString());
        List items = coll.distinct(key);
        for (Object o : items) {
            if (o == null) continue;
            out.add(o.toString());
        }
        return out;
    }

    public Long getLastUpdate(String dci) {
        Long max = 0L;
        BasicDBObject query = new BasicDBObject();
        query.put(DBField.RESOURCE_OWNER.toString(), (Object)dci);
        DBCollection coll = this.db.getCollection(DBCollections.USAGE_RECORDS.toString());
        DBCursor cur = coll.find((DBObject)query);
        while (cur.hasNext()) {
            DBObject dbo = cur.next();
            Long l = (Long)dbo.get(DBField.END_TIME.toString());
            if (l == null || l <= max) continue;
            max = l;
        }
        return max;
    }

    public void addConsumerGroup(String consumerGroup) {
        Vector<String> l = new Vector<String>();
        StringTokenizer st = new StringTokenizer(consumerGroup, ".");
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        this.addConsumerGroup(l);
    }

    public void addConsumerGroup(List<String> consumerGroup) {
        logger.info((Object)("adding group: " + consumerGroup.toString()));
        DBCollection coll = this.db.getCollection(DBCollections.CONSUMERS_RECORDS.toString());
        BasicDBObject query = new BasicDBObject();
        query.put(DBField.SUBSET_GROUP.toString(), consumerGroup);
        DBCursor cur = coll.find((DBObject)query);
        if (!cur.hasNext()) {
            BasicDBObject doc = new BasicDBObject();
            doc.put(DBField.SUBSET_GROUP.toString(), consumerGroup);
            coll.insert(new DBObject[]{doc});
        }
    }

    public Collection<ArrayList<String>> getConsumersGroup() {
        ArrayList<ArrayList<String>> consumersGroup = new ArrayList<ArrayList<String>>();
        DBCollection collCG = this.db.getCollection(DBCollections.CONSUMERS_RECORDS.toString());
        collCG.ensureIndex((DBObject)new BasicDBObject(DBField.SUBSET_GROUP.toString(), (Object)1).append("unique", (Object)true));
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = collCG.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            BasicDBList dblist = (BasicDBList)dbo.get(DBField.SUBSET_GROUP.toString());
            ArrayList<String> current = new ArrayList<String>();
            for (Object object : dblist) {
                current.add((String)object);
            }
            consumersGroup.add(current);
        }
        return consumersGroup;
    }

    private String encodeKey(String key) {
        key = key.replaceAll("\\\\", "\\\\\\\\");
        key = key.replaceAll("\\$", "\\\\DOL");
        key = key.replaceAll("\\.", "\\\\DOT");
        return key;
    }

    private String decodeKey(String key) {
        key = key.replaceAll("\\\\DOT", ".");
        key = key.replaceAll("\\\\DOL", "\\$");
        key = key.replaceAll("\\\\\\\\", "\\\\");
        return key;
    }

    public FilterRating getTaskWorkerTimeFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        ArrayList<String> workingTime = new ArrayList<String>();
        workingTime.add("$rsp:usageEnd");
        workingTime.add("$rsp:usageStart");
        group.put("taskWorkerTime", (Object)new BasicDBObject("$sum", (Object)new BasicDBObject("$subtract", workingTime)));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("taskWorkerTime").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("taskWorkerTime = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getTaskNetworkTrafficInputFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("taskNetworkTrafficInput", (Object)new BasicDBObject("$sum", (Object)("$" + report.getReportProperty())));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double networkTrafficIn = Double.parseDouble(obj.get("taskNetworkTrafficInput").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("networkTrafficIn = " + networkTrafficIn));
            rating.add(new EntryFilterRating(filter, Double.valueOf(networkTrafficIn)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getTaskNetworkTrafficOutputFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("taskNetworkTrafficOutput", (Object)new BasicDBObject("$sum", (Object)("$" + report.getReportProperty())));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("taskNetworkTrafficOutput").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("count = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getTaskCountProcessorsFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("taskCountProcessors", (Object)new BasicDBObject("$sum", (Object)"$rsp:processors"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("taskCountProcessors").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("count = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getJobNetElapsedTimeFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("jobNetElapsedTime", (Object)new BasicDBObject("$sum", (Object)"$rsp:wallDuration"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("jobNetElapsedTime").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("jobNetElapsedTime = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getJobElapsedTimeFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        ArrayList<String> workingTime = new ArrayList<String>();
        workingTime.add("$rsp:jobEnd");
        workingTime.add("$rsp:jobStart");
        group.put("jobElapsedTime", (Object)new BasicDBObject("$sum", (Object)new BasicDBObject("$subtract", workingTime)));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("jobElapsedTime").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("jobElapsedTime = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getJobCountJobsFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("jobCountJobs", (Object)new BasicDBObject("$sum", (Object)1));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("jobCountJobs").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("count = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getServiceCountOperationsFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("serviceCountOperations", (Object)new BasicDBObject("$sum", (Object)"$rsp:invocationCount"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        logger.debug((Object)("Group clause " + groupClause));
        DBObject matchClause = MongoAggregationHelper.generateMatchClause((Report)report);
        logger.debug((Object)("Match clause " + matchClause));
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        DBCollection usageRecodsCollection = this.getUsageRecordsCollection();
        logger.debug((Object)("usage collection " + usageRecodsCollection));
        AggregationOutput output = usageRecodsCollection.aggregate(matchClause, new DBObject[]{existClause, groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double serviceCountOperations = Double.parseDouble(obj.get("serviceCountOperations").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("serviceCountOperations = " + serviceCountOperations));
            rating.add(new EntryFilterRating(filter, Double.valueOf(serviceCountOperations)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getServiceAvgInvocationTimeFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("serviceAvgInvocationTime", (Object)new BasicDBObject("$avg", (Object)"$rsp:averageInvocationTime"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double serviceAvgInvocationTime = Double.parseDouble(obj.get("serviceAvgInvocationTime").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("serviceAvgInvocationTime = " + serviceAvgInvocationTime));
            rating.add(new EntryFilterRating(filter, Double.valueOf(serviceAvgInvocationTime)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getStorageStatusAvgEntitiesFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("storageStatusAvgEntities", (Object)new BasicDBObject("$avg", (Object)"$rsp:dataCount"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("storageStatusAvgEntities").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("storageStatusAvgEntities = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getStorageStatusAvgVolumeFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("storageStatusAvgVolume", (Object)new BasicDBObject("$avg", (Object)"$rsp:dataVolume"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("storageStatusAvgVolume").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("storageStatusAvgVolume = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getStorageStatusVolumeFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("storageStatusVolume", (Object)new BasicDBObject("$last", (Object)"$rsp:dataVolume"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("storageStatusVolume").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("storageStatusVolume = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getStorageStatusEntitiesFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("storageStatusEntities", (Object)new BasicDBObject("$avg", (Object)"$rsp:dataCount"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("storageStatusEntities").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("storageStatusEntities = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getStorageUsageVolumeFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("storageUsageVolume", (Object)new BasicDBObject("$sum", (Object)"$rsp:dataVolume"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("storageUsageVolume").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("count = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getStorageUsageCountEntitiesFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("storageUsageCountEntities", (Object)new BasicDBObject("$sum", (Object)"$rsp:dataCount"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("storageUsageCountEntities").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("count = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public FilterRating getStorageUsageCountOperationsFilter(Report report) {
        FilterRating out = new FilterRating();
        TreeSet<EntryFilterRating> rating = new TreeSet<EntryFilterRating>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)false);
        group.put("storageUsageCountOperations", (Object)new BasicDBObject("$avg", (Object)"$rsp:dataCount"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            double volume = Double.parseDouble(obj.get("storageUsageCountOperations").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("count = " + volume));
            rating.add(new EntryFilterRating(filter, Double.valueOf(volume)));
        }
        out.setRating(rating);
        return out;
    }

    public Collection<AggregatedResult> getTaskNetworkTrafficOutputReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("taskNetworkTrafficOutput", (Object)new BasicDBObject("$sum", (Object)("$" + report.getReportProperty())));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        logger.debug((Object)("groupClause = " + groupClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double volume = Double.parseDouble(obj.get("taskNetworkTrafficOutput").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "taskNetworkTrafficOutput = " + volume));
            AggregatedResult current = new AggregatedResult(time, Metric.SUM, volume, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getTaskNetworkTrafficInputReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("taskNetworkTrafficInput", (Object)new BasicDBObject("$sum", (Object)("$" + report.getReportProperty())));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        logger.debug((Object)("groupClause = " + groupClause));
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double volume = Double.parseDouble(obj.get("taskNetworkTrafficInput").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "taskNetworkTrafficInput = " + volume));
            AggregatedResult current = new AggregatedResult(time, Metric.SUM, volume, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getTaskWorkerTimeReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        ArrayList<String> workingTime = new ArrayList<String>();
        workingTime.add("$rsp:usageEnd");
        workingTime.add("$rsp:usageStart");
        group.put("taskWorkerTime", (Object)new BasicDBObject("$sum", (Object)new BasicDBObject("$subtract", workingTime)));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        logger.debug((Object)("groupClause = " + groupClause));
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double volume = Double.parseDouble(obj.get("taskWorkerTime").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "taskWorkerTime = " + volume));
            AggregatedResult current = new AggregatedResult(time, Metric.SUM, volume, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getTaskCountProcessorsReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("taskCountProcessors", (Object)new BasicDBObject("$sum", (Object)"$rsp:processors"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        logger.debug((Object)("groupClause = " + groupClause));
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double volume = Double.parseDouble(obj.get("taskCountProcessors").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "taskCountProcessors = " + volume));
            AggregatedResult current = new AggregatedResult(time, Metric.SUM, volume, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getJobNetElapsedTimeReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("jobNetElapsedTime", (Object)new BasicDBObject("$sum", (Object)"$rsp:wallDuration"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        logger.debug((Object)("groupClause = " + groupClause));
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double volume = Double.parseDouble(obj.get("jobNetElapsedTime").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "jobNetElapsedTime = " + volume));
            AggregatedResult current = new AggregatedResult(time, Metric.SUM, volume, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getJobElapsedTimeReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        ArrayList<String> workingTime = new ArrayList<String>();
        workingTime.add("$rsp:jobEnd");
        workingTime.add("$rsp:jobStart");
        group.put("jobElapsedTime", (Object)new BasicDBObject("$sum", (Object)new BasicDBObject("$subtract", workingTime)));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        logger.debug((Object)("groupClause = " + groupClause));
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double volume = Double.parseDouble(obj.get("jobElapsedTime").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "jobElapsedTime = " + volume));
            AggregatedResult current = new AggregatedResult(time, Metric.SUM, volume, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getJobCountJobsReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("jobCountJobs", (Object)new BasicDBObject("$sum", (Object)1));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        logger.debug((Object)("groupClause = " + groupClause));
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double volume = Double.parseDouble(obj.get("jobCountJobs").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "jobCountJobs = " + volume));
            AggregatedResult current = new AggregatedResult(time, Metric.SUM, volume, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getServiceCountOperationsReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("serviceCountOperations", (Object)new BasicDBObject("$sum", (Object)"$rsp:invocationCount"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        logger.debug((Object)("groupClause = " + groupClause));
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double volume = Double.parseDouble(obj.get("serviceCountOperations").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "serviceCountOperations = " + volume));
            AggregatedResult current = new AggregatedResult(time, Metric.SUM, volume, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getServiceAvgInvocationTimeReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("serviceAvgInvocationTime", (Object)new BasicDBObject("$avg", (Object)"$rsp:averageInvocationTime"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        logger.debug((Object)("groupClause = " + groupClause));
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double avgInvocationTime = Double.parseDouble(obj.get("serviceAvgInvocationTime").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "serviceAvgInvocationTime = " + avgInvocationTime));
            AggregatedResult current = new AggregatedResult(time, Metric.AVG, avgInvocationTime, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getStorageUsageVolumeReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("storageUsageVolume", (Object)new BasicDBObject("$sum", (Object)"$rsp:dataVolume"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double dataCount = Double.parseDouble(obj.get("storageUsageVolume").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "storageUsageVolume = " + dataCount));
            AggregatedResult current = new AggregatedResult(time, Metric.SUM, dataCount, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getStorageUsageCountEntitiesReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("storageUsageCountEntities", (Object)new BasicDBObject("$sum", (Object)"$rsp:dataCount"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double dataCount = Double.parseDouble(obj.get("storageUsageCountEntities").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "storageUsageCountEntities = " + dataCount));
            AggregatedResult current = new AggregatedResult(time, Metric.SUM, dataCount, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getStorageUsageCountOperationsReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("storageUsageCountOperations", (Object)new BasicDBObject("$sum", (Object)"$rsp:dataCount"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double dataCount = Double.parseDouble(obj.get("storageUsageCountOperations").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "storageUsageCountOperations = " + dataCount));
            AggregatedResult current = new AggregatedResult(time, Metric.COUNT, dataCount, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getStorageStatusEntitiesReport(Report report) {
        return this.getStorageStatusReport(report, "rsp:dataCount");
    }

    public Collection<AggregatedResult> getStorageStatusVolumeReport(Report report) {
        return this.getStorageStatusReport(report, "rsp:dataVolume");
    }

    private Collection<AggregatedResult> getStorageStatusReport(Report report, String valueKey) {
        logger.debug((Object)("getting storage Volume by " + report.getDimension()));
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject matchClause = MongoAggregationHelper.generateMatchClause((Report)report);
        BasicDBObject sortFields = new BasicDBObject();
        sortFields.append("startTime", (Object)1);
        BasicDBObject sortClause2 = new BasicDBObject("$sort", (Object)sortFields);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        DBObject group = MongoAggregationHelper.generateDailyGroupClause();
        logger.debug((Object)("group clause = " + group));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject sortClause = MongoAggregationHelper.generateSortClause((Report)report);
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(matchClause, new DBObject[]{existClause, sortClause2, groupClause, sortClause});
        ResultSet rSet = new ResultSet(report.getDimension());
        for (DBObject obj : output.results()) {
            logger.debug((Object)obj.toMap().toString());
            try {
                rSet.add(new Record(obj, valueKey));
            }
            catch (Exception e) {
                logger.error((Object)("Got an exception adding record to resultset " + e));
                e.printStackTrace();
            }
        }
        long mindate = report.getStartPeriod().getTime();
        long maxdate = report.getEndPeriod().getTime();
        List intervals = UsageTrackerDB.getIntervals((Long)mindate, (Long)maxdate, (String)report.getAggregationGranule());
        for (String dimension : rSet.getDimensionValues()) {
            if ("day".equals(report.getAggregationGranule())) {
                for (Long i : intervals) {
                    double dataVolume = rSet.getSumAt(dimension, i);
                    AggregatedResult current = new AggregatedResult(new DateTime((Object)i), Metric.COUNT, dataVolume, dimension);
                    out.add(current);
                }
                continue;
            }
            for (int i = 1; i < intervals.size(); ++i) {
                double value = rSet.getAverageInRange(dimension, (Long)intervals.get(i - 1), (Long)intervals.get(i));
                AggregatedResult current = new AggregatedResult(new DateTime(intervals.get(i)), Metric.AVG, value, dimension);
                out.add(current);
            }
        }
        Collections.sort((List)out);
        return out;
    }

    public Collection<AggregatedResult> getStorageStatusAvgEntitiesReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("storageStatusAvgEntities", (Object)new BasicDBObject("$avg", (Object)"$rsp:dataCount"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double volume = Double.parseDouble(obj.get("storageStatusAvgEntities").toString());
            String filter = idField.get(report.getDimension()).toString();
            logger.debug((Object)("dimension = " + filter + " - " + "avgEntities = " + volume));
            AggregatedResult current = new AggregatedResult(time, Metric.AVG, volume, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    public static List<Long> getIntervals(Long startMillis, Long endMillis, String granule) {
        Vector<Long> out = new Vector<Long>();
        out.add(startMillis);
        Long current = startMillis;
        while (true) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.setTimeInMillis(current);
            cal.set(11, 0);
            cal.clear(12);
            cal.clear(13);
            cal.clear(14);
            if ("day".equals(granule)) {
                cal.add(5, 1);
            } else if ("week".equals(granule)) {
                cal.set(7, cal.getFirstDayOfWeek());
                cal.add(3, 1);
            } else if ("month".equals(granule)) {
                cal.set(5, 1);
                cal.add(2, 1);
            } else if ("year".equals(granule)) {
                cal.set(6, 1);
                cal.add(1, 1);
            }
            current = cal.getTimeInMillis();
            if (current > endMillis) break;
            out.add(cal.getTimeInMillis());
        }
        out.add(endMillis);
        return out;
    }

    public static void main(String[] args) {
        for (Long l : UsageTrackerDB.getIntervals((Long)1000000000L, (Long)500000000000L, (String)"year")) {
            System.out.println(new Date(l));
        }
    }

    public Collection<AggregatedResult> getStorageStatusAvgVolumeReport(Report report) {
        ArrayList<AggregatedResult> out = new ArrayList<AggregatedResult>();
        DBObject group = MongoAggregationHelper.generateGroupClause((Report)report, (boolean)true);
        group.put("storageStatusAvgVolume", (Object)new BasicDBObject("$avg", (Object)"$rsp:dataVolume"));
        BasicDBObject groupClause = new BasicDBObject("$group", (Object)group);
        DBObject existClause = MongoAggregationHelper.generateExistMatchClause((String)report.getDimension(), (boolean)true);
        logger.debug((Object)("Exist clause " + existClause));
        AggregationOutput output = this.getUsageRecordsCollection().aggregate(MongoAggregationHelper.generateMatchClause((Report)report), new DBObject[]{existClause, groupClause, MongoAggregationHelper.generateSortClause((Report)report)});
        for (DBObject obj : output.results()) {
            DBObject idField = (DBObject)obj.get("_id");
            DateTime time = MongoAggregationHelper.generateAggregationTime((DBObject)idField, (String)report.getAggregationGranule());
            double volume = Double.parseDouble(obj.get("storageStatusAvgVolume").toString());
            String filter = idField.get(report.getDimension()).toString();
            AggregatedResult current = new AggregatedResult(time, Metric.AVG, volume, filter);
            out.add(current);
        }
        Collections.sort((List)out);
        return out;
    }

    static {
        baseFields = new DBField[]{DBField.RESOURCE_TYPE, DBField.CONSUMER_ID, DBField.FULLY_QUALIFIED_CONSUMER_ID, DBField.START_TIME, DBField.END_TIME, DBField.CREATOR_ID, DBField.UR_ID, DBField.CREATE_TIME, DBField.MODIFY_TIME, DBField.RESOURCE_OWNER, DBField.RESOURCE_SCOPE};
        logger = Logger.getLogger(UsageTrackerDB.class);
    }
}

