/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources.filters;

import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.FilterRating;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

@Path(value="/filters/service/")
public class ServiceFilters {
    private static Logger logger = Logger.getLogger(ServiceFilters.class);
    @Context
    protected HttpServletRequest request;

    @POST
    @Path(value="operations")
    @Produces(value={"application/xml"})
    public FilterRating getCountOperationsFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getServiceCountOperationsFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="avg-invocation-time")
    @Produces(value={"application/xml"})
    public FilterRating getAvgInvocationTimeFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getServiceAvgInvocationTimeFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }
}

