/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources.filters;

import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.FilterRating;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

@Path(value="/filters/job/")
public class JobFilters {
    private static Logger logger = Logger.getLogger(JobFilters.class);
    @Context
    protected HttpServletRequest request;

    @POST
    @Path(value="jobs")
    @Produces(value={"application/xml"})
    public FilterRating getCountJobsFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getJobCountJobsFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="elapsed-time")
    @Produces(value={"application/xml"})
    public FilterRating getElapsedTimeFilter(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getJobElapsedTimeFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="net-elapsed-time")
    @Produces(value={"application/xml"})
    public FilterRating getNetElapsedTime(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getJobNetElapsedTimeFilter(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }
}

