/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources.reports;

import java.net.UnknownHostException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.AggregatedResult;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

@Path(value="/reports/storage-status")
public class StorageStatusReports {
    private static Logger logger = Logger.getLogger(StorageStatusReports.class);
    @Context
    protected HttpServletRequest request;

    @POST
    @Path(value="volume")
    @Produces(value={"application/xml"})
    public Collection<AggregatedResult> getVolumeReport(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getStorageStatusVolumeReport(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="entities")
    @Produces(value={"application/xml"})
    public Collection<AggregatedResult> getEntitiesReport(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getStorageStatusEntitiesReport(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="avg-volume")
    @Produces(value={"application/xml"})
    public Collection<AggregatedResult> getAvgVolumeReport(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getStorageStatusAvgVolumeReport(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="avg-entities")
    @Produces(value={"application/xml"})
    public Collection<AggregatedResult> getAvgEntitiesReport(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getStorageStatusAvgEntitiesReport(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }
}

