package org.gcube.accounting.usagetracker.consumer;



import java.util.List;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;


import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.messaging.QueueCouple;
import org.gcube.accounting.messaging.ResourceAccounting;
import org.gcube.accounting.messaging.ResourceAccountingFactory;
import org.gcube.accounting.usagetracker.configuration.Configuration;
import org.gcube.accounting.ut.UsageTrackerRestAPI;

/**
 * 
 * @author Ermanno Travaglino (E-IIS)
 *
 *
 */
public class UTConsumer implements Runnable, ServletContextListener {

	private static Logger logger = Logger.getLogger(UTConsumer.class);

	private QueueCouple queueCouple;


	public UTConsumer(){
	}

	
	public UTConsumer(QueueCouple queueCouple){
		this.queueCouple = queueCouple;
	}


	public void run() {


		// to enhance with a dynamic configuration for the UT's endpoint 
		UsageTrackerRestAPI ut = new UsageTrackerRestAPI("http://localhost:8080/usagetracker/rest");//this.configuration.getDestinationUTUrl());
		
		ResourceAccounting raFactory = null;
		try {
			raFactory = ResourceAccountingFactory.getResourceAccountingInstance();
			logger.info("getting Resource Accounting factory");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}



		while (true) {
			//QueueCouple queueCouple = new QueueCouple("tcp://192.168.125.190:61616", "/testing");
			RawUsageRecord ur = raFactory.receiveAccountingMessage(queueCouple);
			logger.info("new UR retrieved : "+ur.getId());
			
			publishAccountingRecord(ut, ur);

			try {
				//				this.info("sleeping for "
				//						+ this.configuration.getPublishInterval() + " minutes");
				Thread.sleep(10);


				//.sleep(this.configuration.getPublishInterval() * 60 * 1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
				// } catch (ConfigurationException e) {
				// this.error("Terminating.");
				// break;
			}

		}
	}


	private void publishAccountingRecord(UsageTrackerRestAPI ut, RawUsageRecord ur) {
		logger.info("publishing new record on the usage tracker : "+ur.getId());
		ut.insertUsageRecord(ur);


	}
	
	public void contextInitialized(ServletContextEvent event) {
		List<Object> scopes = Configuration.getInstance().getScopes();
		String broker = Configuration.getInstance().getBroker();
		
		logger.info("starting UTConsumer on broker "+broker+" with scopes "+scopes);

		for (Object scope : scopes) {
			QueueCouple couple = new QueueCouple(broker, (String) scope);
			Thread t = new Thread(new UTConsumer(couple));
			t.start();


		}
	}


	@Override
	public void contextDestroyed(ServletContextEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	

}
