/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.persistence;

import java.util.HashMap;
import java.util.Map;
import org.gcube.accounting.usagetracker.persistence.Helper;
import org.gcube.accounting.usagetracker.persistence.Record;
import org.gcube.accounting.usagetracker.persistence.SortedRecords;

class DimensionValueMap {
    private String dimensionKey;
    private Map<String, SortedRecords> fields2records;

    public DimensionValueMap(String dimensionKey) {
        this.dimensionKey = dimensionKey;
        this.fields2records = new HashMap();
    }

    public void add(Record r) {
        String key = Helper.getKeyExcluding((Record)r, (String)this.dimensionKey);
        if (!this.fields2records.containsKey(key)) {
            this.fields2records.put(key, new SortedRecords());
        }
        ((SortedRecords)this.fields2records.get(key)).add(r);
    }

    public Double getSumAt(Long timestamp) {
        Double out = 0.0;
        for (String key : this.fields2records.keySet()) {
            Record r = ((SortedRecords)this.fields2records.get(key)).getEarlierRecord(timestamp);
            if (r == null) continue;
            out = out + r.getValue();
        }
        return out;
    }
}

