package org.gcube.accounting.messaging;

import java.util.HashMap;

import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.log4j.Logger;
import org.gcube.common.messaging.endpoints.BrokerEndpoints;
import org.gcube.common.messaging.endpoints.BrokerNotConfiguredInScopeException;
import org.gcube.common.messaging.endpoints.ScheduledRetriever;
import org.gcube.common.scope.api.ScopeProvider;




/**
 * 
 * 
 * @author Andrea Manzi(CERN)
 * @author Ermanno Travaglino (E-IIS)
 *
 */
public class ConnectionsManager {

	private static long refreshTime = 1800;

	private static long waitingTime = 60;


	private static Logger logger = Logger.getLogger(ConnectionsManager.class);



	/**ActiveMQ Connection factory**/
	private static HashMap<String,ActiveMQConnectionFactory> connectionFactoryMap = null;

	private static HashMap<String,QueueConnection> queueConnectionMap = null;

	static {
		
		connectionFactoryMap = new HashMap<String,ActiveMQConnectionFactory>();

		queueConnectionMap = new HashMap<String, QueueConnection>();

	}


	public void init(long waitingTime, long refreshTime)
	{
		ConnectionsManager.refreshTime= refreshTime;
		ConnectionsManager.waitingTime = waitingTime;

	}


	/**
	 * Get the QueueConnection list for the given scope
	 * @return the queue Connection list for the given scope
	 */
	public static QueueConnection getQueueConnection(String scope){
		QueueConnection connection = queueConnectionMap.get(scope);
		if( connection == null ) {
			logger.debug("CONNECTION MAP NULL");
		}
		return connection;
	}

	/**
	 * Add the Scope to the monitoredMap
	 * @return the scope to add
	 * @throws org.gcube.common.messaging.endpoints.BrokerNotConfiguredInScopeException 
	 * @throws Exception 
	 */
	public synchronized static void addScope (String scope) throws BrokerNotConfiguredInScopeException, Exception{

		ScopeProvider.instance.set(scope);
		logger.debug("scope added");
		logger.debug("getRetriever");
		BrokerEndpoints.getRetriever(waitingTime, refreshTime);
		logger.debug("broker retrieved");
		reloadConnection(scope);

	}

	/**
	 * 
	 * @return 
	 * @throws Exception 
	 * @throws BrokerNotConfiguredInScopeException 
	 */
	public  static ScheduledRetriever getBrokerRetriever (String scope) throws BrokerNotConfiguredInScopeException, Exception 
	{
		ScopeProvider.instance.set(scope);
		return BrokerEndpoints.getRetriever(waitingTime, refreshTime);
	}



	/**
	 * Reload the scope connection
	 * @param scope the scope to reload
	 */
	public synchronized static void reloadConnection(String scope) {

		//close current connections:
		stopConnections(scope);
		ActiveMQConnectionFactory factory =null;
		
		QueueConnection queueConnection = null;

		logger.debug("Reload JMS connections");

		try {
			//logger.info("MSG-Broker failover endpoint found: "+getBrokerRetriever(scope).getFailoverEndpoint()+" for scope: "+scope.toString());

			//factory = new ActiveMQConnectionFactory("tcp://192.168.125.190:61616");
			factory = new ActiveMQConnectionFactory(getBrokerRetriever(scope).getEndpoints().get(0));

			queueConnection = ((QueueConnectionFactory)factory).createQueueConnection();
			queueConnection.start();

		} catch (JMSException e1) {
			logger.debug("Error creating Topic Connection - jms");
		} catch (Exception e) {
			e.printStackTrace();
			logger.debug("Error creating Topic Connection - general");
		}

		queueConnectionMap.put(scope,queueConnection);
		connectionFactoryMap.put(scope, factory);

	}


	private static void stopConnections(String scope){


		if (queueConnectionMap != null  && queueConnectionMap.get(scope) != null) {
			//close current connections:
			QueueConnection con =queueConnectionMap.get(scope);
			try {
				con.stop();
				con.close();
			}
			catch (JMSException e ){
				logger.debug("Error stopping queueConnections");
			}
		}

	}


}
