/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.messaging.consumer;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.messaging.QueueCouple;

public class Consumer {
    private static Consumer singleton;
    protected static boolean transacted;
    protected static int ackMode;
    private static String subject;

    private Consumer() {
    }

    public static Consumer getSingleton() {
        return singleton;
    }

    public RawUsageRecord receiveMessageFromQueue(QueueCouple queueCouple) {
        RawUsageRecord p = null;
        System.out.println("receiveMessageFromQueue");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(queueCouple.getBroker());
        try {
            Connection connection = connectionFactory.createConnection();
            System.out.println("new Connection");
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(queueCouple.getScope() + "." + subject);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            System.out.println("Consumer waiting...");
            Message message = consumer.receive();
            System.out.println("new Message");
            if (message instanceof ObjectMessage) {
                ObjectMessage obj = (ObjectMessage)message;
                p = (RawUsageRecord)obj.getObject();
                System.out.println("Received" + p.getId());
            } else {
                System.out.println("Received message of unknown type");
            }
            consumer.close();
            session.close();
            connection.close();
        }
        catch (JMSException e) {
            System.out.println("Problem creating connection to ActiveMQ");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    static {
        transacted = false;
        ackMode = 1;
        subject = "resource-accounting";
        singleton = new Consumer();
    }
}

