package org.gcube.accounting.messaging;


import java.io.IOException;

import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.messaging.consumer.Consumer;
import org.gcube.accounting.messaging.producer.Producer;

/** 		
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class MSGClient {

	//private static Logger logger = Logger.getLogger(MSGClient.class);

	protected MSGClient() throws IOException{
	}

	
	/**
	 * {@inheritDoc}
	 */
	public void sendMessage(RawUsageRecord message) {
		
		//logger.debug("MSGClient is going to send a message");
		Producer.getSingleton().sendMessageToQueue(message);
	}

	
	/**
	 * {@inheritDoc}
	 */
	public RawUsageRecord receiveMessage(QueueCouple queueCouple) {
		
		//logger.debug("MSGClient is going to receive a message");
		return Consumer.getSingleton().receiveMessageFromQueue(queueCouple);
	}



	
}