

package org.gcube.accounting.datamodel;

import java.util.Calendar;
import java.util.Map;

import org.gcube.accounting.exception.InvalidValueException;

public interface UsageRecord {

	/**
	 * Return the creation time for this usage record
	 * 
	 * @return
	 */
	public Calendar getCreateTime();

	/**
	 * Set the creation time for this usage record
	 * 
	 * @param createTime
	 */
	public void setCreateTime(Calendar createTime);

	/**
	 * Return the modify time for this usage record
	 * 
	 * @return
	 */
	public Calendar getModifyTime();

	/**
	 * Set the modification time for this usage record
	 * 
	 * @param modifyTime
	 */
	public void setModifyTime(Calendar modifyTime) throws InvalidValueException;

	/**
	 * Return the identity of the entity creating this usage record
	 * 
	 * @returnget
	 */
	public String getCreatorId();

	/**
	 * Set the identity of the entity creating this usage record
	 * 
	 * @param creatorId
	 */
	public void setCreatorId(String creatorId);

	/**
	 * Return the identity of the entity that consumed the resource
	 * 
	 * @return
	 */
	public String getConsumerId();

	/**
	 * Set the identity of the entity that consumed the resource
	 * 
	 * @return
	 */
	public void setConsumerId(String consumerId);

	/**
	 * @return
	 */
//	public String getConsumerMembership();

	/**
	 * @return
	 */
	public String getFullyQualifiedConsumerId();

	
	/**
	 * @return
	 */
	public void setFullyQualifiedConsumerId(String fqcid);

	/**
	 * Return the left end of the time interval covered by this usage record
	 * 
	 * @return
	 */
	public Calendar getStartTime();

	/**
	 * Set the left end of the time interval covered by this usage record
	 * 
	 * @return
	 */
	public void setStartTime(Calendar startTime) throws InvalidValueException;

	/**
	 * Return the right end of the time interval covered by this usage record
	 * 
	 * @return
	 */
	public Calendar getEndTime();

	/**
	 * Set the right end of the time interval covered by this usage record
	 * 
	 * @return
	 */
	public void setEndTime(Calendar endTime) throws InvalidValueException;

	/**
	 * Return the unique id for this usage record
	 * 
	 * @return
	 */
	public String getId();

	/**
	 * Set the unique id for this usage record
	 * 
	 * @param id
	 */
	public void setId(String id);

	/**
	 * Return the id of the usage record aggregating this
	 * 
	 * @return
	 */
	public String getAggregatedId();

	/**
	 * Set the id of the usage record aggregating this
	 * 
	 * @param aggregatedId
	 */
	public void setAggregatedId(String aggregatedId);

	/**
	 * Return the type of the resource this usage records refers to
	 * 
	 * @return
	 */
	public String getResourceType();

	/**
	 * Set the type of the resource this usage records refers to
	 * 
	 * @param resourceType
	 */
	public void setResourceType(String resourceType);

	/**
	 * Return the identity of the owner of the resource
	 * 
	 * @return
	 */
	public String getResourceOwner();

	/**
	 * Set the scope of the resource
	 * 
	 * @return
	 */
	public void setResourceScope(String scope);
	
	/**
	 * Return the scope of the resource
	 * 
	 * @return
	 */
	public String getResourceScope();

	/**
	 * Set the scope of the resource
	 * 
	 * @return
	 */
	public void setResourceOwner(String owner);

	/**
	 * Return the value of the given resource-specific property
	 * 
	 * @param name
	 * @return
	 */
	public String getResourceSpecificProperty(String name);

	/**
	 * Set the value of the given resource-specific property
	 * 
	 * @param key
	 * @param value
	 */
	public void setResourceSpecificProperty(String key, String value);

	/**
	 * Return the value of the given user-defined property
	 * 
	 * @param name
	 * @return
	 */
	public String getCustomProperty(String name);

	/**
	 * Set the value of the given user-defined property
	 * 
	 * @param name
	 * @return
	 */
	public void setCustomProperty(String name, String value);

	/**
	 * Return all resource-specific properties
	 * 
	 * @return
	 */
	public Map<String, String> getResourceSpecificProperties();

	/**
	 * Set all resource-specific properties, replacing existing ones
	 * 
	 * @return
	 */
	public void setResourceSpecificProperties(Map<String, String> props);

	/**
	 * Return all user-defined properties
	 * 
	 * @return
	 */
	public Map<String, String> getCustomProperties();

	/**
	 * Set all user-defined properties, replacing existing ones
	 * 
	 * @return
	 */
	public void setCustomProperties(Map<String, String> props);

	public void validate() throws InvalidValueException;
	
}
