

package org.gcube.accounting.datamodel.serialization;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "entry")
public class AdaptedMapEntry {

	@XmlElement(name = "name", required = true)
	private final String key;

	@XmlElement(name = "value", required = true)
	private final String value;

	public AdaptedMapEntry(String key, String value) {
		this.key = key;
		this.value = value;
	}

	public AdaptedMapEntry() {
		this.key = null;
		this.value = null;
	}

	public String getKey() {
		return key;
	}

	public String getValue() {
		return value;
	}
}
