

package org.gcube.accounting.datamodel;

import java.util.List;
import java.util.Vector;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

/**
 * 
 * Bean used to implement a mappable map
 * 
 */
public class Property {

	String name;
	List<String> values;

	public Property() {

	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@XmlElementWrapper(name="values")
	@XmlElement(name="value")
	public List<String> getValues() {
		return values;
	}

	public void setValues(List<String> values) {
		this.values = values;
	}
	
	public void addValue(String value) {
		if(this.values==null)
			this.values=new Vector<String>();
		this.values.add(value);
	}

}
