
function createWMSFeatureControl(layerObject){

	// show all control panel elements
	var panelChild, children = layerObject.div.children;
	for(var i=0;i<children.length;i++){
		var current = $(children[i]);
		if(current.attr("id")==undefined)
			continue;
		current.children().show();
		panelChild = current;
	}
	
	//add a control on the map for this layer
	
	/*
	//case OPTIONS request
	var protocol = OpenLayers.Protocol.WFS.fromWMSLayer(layerObject);
	
	var wfs_options = {
		    url: protocol.url,
		    params: {
		        request: "GetFeature",
		        service: "wfs",
		        version: "1.0.0",
		        typeName: protocol.featurePrefix+":"+protocol.featureType
		    },
		    format: new OpenLayers.Format.GML({
		        featureNS: protocol.featureNS,
		        geometryName: protocol.geometryName
		    })
		}
	
	var multiSelect = new OpenLayers.Control.GetFeature({
//		protocol: OpenLayers.Protocol.WFS.fromWMSLayer(layerObject), 
		protocol: new OpenLayers.Protocol.HTTP(wfs_options),
        box: true,
        click: true
    });
	 */
	 
	//case POST request 
	var multiSelect = new OpenLayers.Control.GetFeature({
		protocol: OpenLayers.Protocol.WFS.fromWMSLayer(layerObject), 
        box: true,
        click: true
    });
	
	
	
	multiSelect.protocol.version = "1.0.0";
	
//	multiSelect.protocol.callbackKey = "format_options";
//	multiSelect.protocol.callbackPrefix = "callback";


	
//	multiSelect.events.register("beforefeaturesselected",this, function(e) {
//		console.log("beforefeaturesselected");
//	});
	multiSelect.events.register("featuresselected", this, function (e) {visualiseAdvancedFeatures(e)});
//	multiSelect.events.register("featureselected", this, function () {console.log("featureselected")});
	
	
	
//	multiSelect.protocol.options.outputFormat = 'json';
//	multiSelect.protocol.options.params.outputFormat = 'json';
	

	//here i set the cql filter from the bars 
	multiSelect.handlers.box.callbacks.start = function(e){
		
		var lowDate = new Date($(panelChild).find(".ui-slider").slider("option","values")[0]);
		var highDate = new Date($(panelChild).find(".ui-slider").slider("option","values")[1]);
		var CQL_FILTER = layerObject.dateColumnName+" during "+dateCQLReady(lowDate)+"/"+dateCQLReady(highDate)+ " and "+layerObject.dateColumnName+" is not null";
		
		multiSelect.barValues = {
			'lowDate':$(panelChild).find(".ui-slider").slider("option","values")[0],
			'highDate':$(panelChild).find(".ui-slider").slider("option","values")[1]
		}
		
//		var ol_filter = new OpenLayers.Filter.Comparison({
//			type: OpenLayers.Filter.Comparison.BETWEEN,
//			property: "opengeo:datecollected",
//			lowerBoundary: $(panelChild).find(".ui-slider").slider("option","values")[0],
//			upperBoundary: $(panelChild).find(".ui-slider").slider("option","values")[1]
//		});
	 
//		var filter_1_0 = new OpenLayers.Format.Filter({version: "1.0.0"});
//		var xml = new OpenLayers.Format.XML(); 
//		var filter_param = xml.write(filter_1_0.write(ol_filter));
		
//		layerObject.params['FILTER'] = filter_param;
		
//		var filterStrategy = new OpenLayers.Strategy.Filter({filter: ol_filter});
//		layerObject.strategies = [new OpenLayers.Strategy.Fixed(), filterStrategy];
		

//		multiSelect.protocol = OpenLayers.Protocol.WFS.fromWMSLayer(layerObject);
//		multiSelect.protocol.version = "1.0.0";
		
//		protocol: OpenLayers.Protocol.WFS.fromWMSLayer(layerObject, {
//			filter: filter_param
//		});
		
//		layerObject.params.filter = filter_param;
		
		multiSelect.protocol.options.cql_filter =  CQL_FILTER;
		
		multiSelect.protocol.options.params = {"cql_filter":CQL_FILTER};
//		multiSelect.protocol.params["cql_filter"] = CQL_FILTER;//.params={CQL_FILTER:CQL_FILTER};
		multiSelect.vendorParams = {"cql_filter": CQL_FILTER};
		
//		multiSelect.vendorParams.cql_filter = CQL_FILTER;
		
//		multiSelect.protocol.options.params = {
//			"cql_filter" :  "INCLUDE;("+CQL_FILTER+")"
//		};
		
	}
	

	
//	var callback_done = multiSelect.handlers.box.callbacks.done;
//	multiSelect.handlers.box.callbacks.done = function(bounds) {
//		callback_done();
//		
//	}
	
	
	multiSelect.deactivate();
	layerObject.map.addControl(multiSelect);
	//add a callback on change of the drop-down menu to switch selection mode and initiate the popup with the ribbon !
	var panelSelector = panelChild.find('select');
	panelSelector.change(function(evt){
			if(panelSelector.val()=="nav")
				multiSelect.deactivate();
			else
				multiSelect.activate();
		}
	);
	//also deactivate when layer is deactivated (that's important)
	layerObject.events.register("visibilitychanged", layerObject, function(){multiSelect.deactivate();});
	
	return multiSelect;
}


function protocolExists (map, control){
	var exists = false;
	
	for(var i=0;i<map.controls.length;i++){
		if(!(map.controls[i] instanceof OpenLayers.Control.GetFeature)) //if it's not a GetFeature control, skip it
			continue;
		if((map.controls[i].protocol.featureType === control.protocol.featureType)
				&& (map.controls[i].protocol.featurePrefix === control.protocol.featurePrefix))
			exists = true;
	}
	return exists;
}



function visualiseHTMLFeatures(e) {
	if(e.text.indexOf("<table")==-1)
		return;
	var popup = new OpenLayers.Popup("VisualisationPopup",
			e.object.map.getLonLatFromPixel(e.xy),
            new OpenLayers.Size(200,200),
            e.text,
            true);
	e.object.map.addPopup(popup);
	popup.updateSize();
	//console.log(JSON.stringify(e.features));
}






function visualiseAdvancedFeatures(e) {
	switch(e.features.length)
	{
	case 0:
//		console.log("none selected");
	  return;
	case 1:
		visualiseSingleFeature(e);
	  break;
	default:
		visualiseMultipleFeatures(e);
	}
	
	
}

function visualiseSingleFeature(e) {
	console.log("visualiseSingle");
}

function visualiseMultipleFeatures(e) {
	console.log("visualiseMultiple");
	//create jQuery popup selection panel
	var tempUL = $('<ul/>', {
	    id: 'tempMenu'
	});
	var optionsArray = new Array();
	optionsArray.push("BubblePlot");
	optionsArray.push("CumulativePlot");
	optionsArray.push("Cancel");
	for(var option in optionsArray){
		var tempLI = $('<li/>', {}).appendTo(tempUL);
		$('<a/>',{
//			href:"#",
			text: optionsArray[option]
		}).appendTo(tempLI);
	}

	
	//create the popup to hold the selection panel
	var tempPopup = new OpenLayers.Popup("popupMenu",
			e.object.map.getLonLatFromPixel(
					e.object.map.getControl("olControlMousePosition")!=null ?
							e.object.map.getControl("olControlMousePosition").lastXy : 
							 {x : e.object.map.getSize().w/2,y : e.object.map.getSize().h/2}	
			),
            new OpenLayers.Size(50,50),
            "",
            false
    );
	tempPopup.setBackgroundColor("transparent");
	e.object.map.addPopup(tempPopup);
	
	var menu = $(tempUL).menu();
	$(tempPopup.contentDiv).append(tempUL);
	tempPopup.updateSize();
	
	menu.on( "menuselect", function( event, ui ) {
		$(menu).parent().parent().parent().remove();
		switch(ui.item.text())
		{
		case "BubblePlot":
			bubbleplot(e);
			break;
		case "CumulativePlot":
			cumulativeplot(e);
			break;
		case "Cancel":
			//another visualisation type
			break;
		}
		
		
	});
	
}



function bubbleplot(e){
	
	var popupSize = new OpenLayers.Size(e.object.map.getSize().w-30,e.object.map.getSize().h-30);
	
	var popup = new OpenLayers.Popup( "VisualisationPopup",
		e.object.map.getLonLatFromPixel({x:15,y:15}),
		popupSize,
	    "",
	    false
	);
	e.object.map.addPopup(popup);
	popup.panIntoView();
	popup.padding = 20;
	
	popup.addCloseBox(function(){
		popup.destroy();
	});
	
	//this fixes the overflow problem
	$(popup.contentDiv).css({ 'overflow': 'hidden'});
	//this fixes the close button visibility
	$(popup.closeDiv).css({ 'z-index': $(popup.groupDiv).parent().css("z-index")});
	
	var visFieldsArray = {"idFieldName":"scientific_name", "populationFieldName":"occurrences", "skewFieldName":"skew"};
	
	doBubbleVisualiseJSON(constructBubbleVisJSON(e), JSON.stringify(visFieldsArray), popup.contentDiv.id, popupSize.w, popupSize.h);
	
}

function constructBubbleVisJSON(e){
	
	//first sort the e.features array by the sname
	function SortByName(a, b){
		  var aName = a.data.sname;//.toLowerCase();
		  var bName = b.data.sname;//.toLowerCase(); 
		  return ((aName < bName) ? -1 : ((aName > bName) ? 1 : 0));
		}
	e.features.sort(SortByName);
	
	//now make the computations :)
	var data = Array();
	var dates = Array();
	var sname, occurrences, minDate,maxDate,sumDate;
	sname = e.features[0].data.sname;
	minDate = Date.parse(e.features[0].data.datecollected);
	maxDate = minDate;
	aDate = Date.parse(e.features[0].data.datecollected);
	sumDate = 0;
	occurrences = 1;
	dates.push(Date.parse(e.features[0].data.datecollected));
	for(var i=1;i<e.features.length;i++){
		if(e.features[i].data.sname == sname){
			occurrences++;
			var d = Date.parse(e.features[i].data.datecollected);
			sumDate += d-aDate;
			if(d<minDate)
				minDate = d;
			if(d>maxDate)
				maxDate = d;
			dates.push(d);
		}
		if(e.features[i].data.sname != sname){
			//save the computed values to the array
			data.push({
				'sname':sname,
				'occurrences':occurrences,
				'dates':dates,
				'minDate':minDate,
				'maxDate':maxDate,
				'meanDate':(sumDate/occurrences)+aDate
			});
			//and reset them to current 
			sname = e.features[i].data.sname;
			minDate = Date.parse(e.features[i].data.datecollected);
			maxDate = minDate;
			aDate = minDate;
			sumDate = 0;
			occurrences = 1;
			dates = []; dates.push(Date.parse(e.features[i].data.datecollected));
		}
	}
	//last object (special case)
	data.push({
		'sname':sname,
		'occurrences':occurrences,
		'dates':dates,
		'minDate':minDate,
		'maxDate':maxDate,
		'meanDate':(sumDate/occurrences)+aDate
	});
	
	var lowBarDate = e.object.barValues.lowDate;
	var highBarDate = e.object.barValues.highDate;
	var halfBarWidth = (highBarDate-lowBarDate)/2;
	var middleBarDate = lowBarDate + halfBarWidth;
	e = []; //in order to free up some memory ! (if that actually works)
	
	for(var idx=0; idx<data.length; idx++){
		var skew = 0;
		for(var di=0; di<data[idx].dates.length; di++)
			skew += (data[idx].dates[di] - middleBarDate)/halfBarWidth;
		skew /= data[idx].occurrences;
		data[idx].skew = skew;
	}
	
	//we construct the visualisation fields in the form of 
	//{"idFieldName":"scientific_name", "populationFieldName":"occurrences", "skewFieldName":"skew"}
	//and then we construct the dataJSON input
	
	//construct array
	var visArray = {
			"type": "FeatureCollection",
			"features": new Array()
	}
	for(var i=0;i<data.length;i++){
		visArray.features.push({
	      "properties": {
	        "scientific_name": data[i].sname,
	        "occurrences": data[i].occurrences,
	        "skew": data[i].skew
	      }
	    });
	}
	
	return JSON.stringify(visArray);
	
}


function cumulativeplot(e){
	
	var popupSize = new OpenLayers.Size(e.object.map.getSize().w-30,e.object.map.getSize().h-30);
	
	var popup = new OpenLayers.Popup( "VisualisationPopup",
		e.object.map.getLonLatFromPixel({x:15,y:15}),
		popupSize,
	    "",
	    false
	);
	
	e.object.map.addPopup(popup);
	popup.panIntoView();
	popup.padding = 20;
	
	popup.addCloseBox(function(){
		popup.destroy();
	});
	
	//this fixes the overflow problem
	$(popup.contentDiv).css({ 'overflow': 'hidden'});
	//this fixes the close button visibility
	$(popup.closeDiv).css({ 'z-index': $(popup.groupDiv).parent().css("z-index")});
	
	doCumulativeVisualise(constructCumulativeVisArray(e), popup.contentDiv.id, popupSize.w, popupSize.h);
	
}

function constructCumulativeVisArray(e){
	
	function removeAttributesWithoutDateField(){ //this should be removed when the WMS GetFeature() returns time filtered instances
		var features = new Array();
		for(var i=0;i<e.features.length;i++)
			if(e.features[i].data['datecollected'] != undefined)
				features.push(e.features[i]);
		e.features = features;
	}
	console.log("before: "+e.features.length);
	removeAttributesWithoutDateField();
	console.log("after: "+e.features.length);
	
	function SortByDate(a, b){
		var aDate = a[0];
		var bDate = b[0];
		return ((aDate < bDate) ? -1 : ((aDate > bDate) ? 1 : 0));
	}
	
	//first sort the e.features array by the sname
	function SortByName(a, b){
		var aName = a.data.sname;//.toLowerCase();
		var bName = b.data.sname;//.toLowerCase(); 
		return ((aName < bName) ? -1 : ((aName > bName) ? 1 : 0));
	}
	e.features.sort(SortByName);
	
	//now make the computations :)
	var data = Array();
	var values = Array();
	var sname;
	sname = e.features[0].data.sname;
	values.push(new Array(
		Date.parse(e.features[0].data.datecollected),
		0
	));
	
	for(var i=1;i<e.features.length;i++){
		if(e.features[i].data.sname == sname){
			values.push(new Array(
				Date.parse(e.features[i].data.datecollected),
				0
			));
		}
		if(e.features[i].data.sname != sname){
			//sort by date the values
			values.sort(SortByDate);
			//append the incremental val
			for(var v=0;v<values.length;v++)
				values[v][1] = v;
			//save the computed values to the array
			data.push({
				'key':sname,
				'values':values
			});
			//and reset them to current 
			sname = e.features[i].data.sname;
			values = [];
			values.push(new Array(
				Date.parse(e.features[i].data.datecollected),
				0
			));
		}
	}
	//sort by date the vayerslues
	values.sort(SortByDate);
	//append the incremental val
	for(var v=0;v<values.length;v++)
		values[v][1] = v;
	//last object (special case)
	data.push({
		'key':sname,
		'values':values
	});
	
	return data;
//	return JSON.stringify(data);
}
