package org.visualisation.client;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

import org.gwtopenmaps.openlayers.client.Bounds;
import org.gwtopenmaps.openlayers.client.LonLat;
import org.gwtopenmaps.openlayers.client.Map;
import org.gwtopenmaps.openlayers.client.MapOptions;
import org.gwtopenmaps.openlayers.client.MapWidget;
import org.gwtopenmaps.openlayers.client.Projection;
import org.gwtopenmaps.openlayers.client.StyleMap;
import org.gwtopenmaps.openlayers.client.control.Control;
import org.gwtopenmaps.openlayers.client.control.LayerSwitcher;
import org.gwtopenmaps.openlayers.client.control.MousePosition;
import org.gwtopenmaps.openlayers.client.control.OverviewMap;
import org.gwtopenmaps.openlayers.client.control.ScaleLine;
import org.gwtopenmaps.openlayers.client.event.MapClickListener;
import org.gwtopenmaps.openlayers.client.event.MapClickListener.MapClickEvent;
import org.gwtopenmaps.openlayers.client.feature.VectorFeature;
import org.gwtopenmaps.openlayers.client.format.GeoJSON;
import org.gwtopenmaps.openlayers.client.format.KML;
import org.gwtopenmaps.openlayers.client.geometry.Geometry;
import org.gwtopenmaps.openlayers.client.geometry.Point;
import org.gwtopenmaps.openlayers.client.layer.Layer;
import org.gwtopenmaps.openlayers.client.layer.OSM;
import org.gwtopenmaps.openlayers.client.layer.RendererOptions;
import org.gwtopenmaps.openlayers.client.layer.TMS;
import org.gwtopenmaps.openlayers.client.layer.TMSOptions;
import org.gwtopenmaps.openlayers.client.layer.Vector;
import org.gwtopenmaps.openlayers.client.layer.VectorOptions;
import org.gwtopenmaps.openlayers.client.layer.WMS;
import org.gwtopenmaps.openlayers.client.layer.WMSParams;
import org.gwtopenmaps.openlayers.client.protocol.HTTPProtocol;
import org.gwtopenmaps.openlayers.client.protocol.HTTPProtocolOptions;
import org.gwtopenmaps.openlayers.client.protocol.Protocol;
import org.gwtopenmaps.openlayers.client.util.JSObject;


import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.StyleInjector;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class InteractiveLayers implements EntryPoint {

	public void onModuleLoad() {
//		buildWMSPanel();
	}
	
	//this is just to test with a sample structure.
	void buildWMSPanel(){
//		PopupPanel panel = new PopupPanel(false);
		Projection DEFAULT_PROJECTION = new Projection("EPSG:4326");

		// create some MapOptions
		MapOptions defaultMapOptions = new MapOptions();
		defaultMapOptions.setNumZoomLevels(16);
		final MapWidget mapWidget = new MapWidget("1000px", "800px", defaultMapOptions);

		
		WMSParams params = new WMSParams();
		params.setFormat("image/png");
		params.setStyles("");
		params.setLayers("openstreetmap"); // "bluemarble"  or "openstreetmap"
		WMS wmsLayer = new WMS("WMS Layer","http://maps" +
				".opengeo.org/geowebcache/service/wms",params);
		
//		WMSParams params = new WMSParams();
//		params.setFormat("image/png");
//		params.setStyles("");
//		params.setLayers("basic");
//		WMS wmsLayer = new WMS("WMS Layer","http://vmap0.tiles.osgeo.org/wms/vmap0",params); //http://labs.metacarta.com/wms/vmap0
		

		
		
		final Map map = mapWidget.getMap();

		map.addLayer(wmsLayer);

		// Lets add some default controls to the map
		map.addControl(new LayerSwitcher()); // + sign in the upperright corner
												// to display the layer switcher
//		map.addControl(new OverviewMap()); // + sign in the lowerright to
											// display the overviewmap
		map.addControl(new ScaleLine()); // Display the scaleline
		
		map.addControl(new MousePosition()); 

		// Center and zoom to a location
//		LonLat lonLat = new LonLat(23.635,37.966);
		LonLat lonLat = new LonLat(-80,50);
		
		lonLat.transform(DEFAULT_PROJECTION.getProjectionCode(), map.getProjection()); // transform lonlat to OSM coordinate system
//		map.setCenter(lonLat, 14);
		map.setCenter(lonLat, 2);

//		mapWidget.getElement().getFirstChildElement().getStyle().setZIndex(0); 
		
//		Layer arrowLayer = OpenLayers.createArrowLayer("migrations");
//		OpenLayers.addArrow(arrowLayer, new Point(10, 10), new Point(20, 20));
//		OpenLayers.removeAllArrows(arrowLayer);
//		map.addLayer(arrowLayer);
		
		
//		Button a = new Button("show map");
//		RootPanel.get().add(a);
//		a.addMouseDownHandler(new MouseDownHandler() {
//			
//			public void onMouseDown(MouseDownEvent event) {
//		  		Layer barLayer = OpenLayers.createInteractiveLayer("http://geoserver2.d4science.research-infrastructures.eu/geoserver/wms", "aquamaps" , "lmolamola20121207162518938cet", "layerSlider", new Date(), new Date());
//				map.addLayer(barLayer);
//				RootPanel.get().add(mapWidget);
//			}
//		});
		
		Date startDate = new Date(1901-1900,10,10);
		Date endDate = new Date(2010-1900,10,10);
//		try {
//			startDate = (Date)formatter.parse("11-11-1950");
//			endDate = (Date)formatter.parse("11-11-2010");
//		} catch (ParseException e) {e.printStackTrace();}
		
//		Layer barLayer = OpenLayers.createInteractiveFilterLayer("http://geoserver2.d4science.research-infrastructures.eu/geoserver/wms", "timeseriesws" , "animalia_fishbase", "layerSlider",  "datecollected", startDate, endDate);
//		map.addLayer(barLayer);
//		RootPanel.get().add(mapWidget);
		
//		Layer filterClickLayer = OpenLayers.createInteractiveFilterLayer("http://geoserver2.d4science.research-infrastructures.eu/geoserver/wms", "timeseriesws" , "animalia_fishbase", "layerSlider",  "datecollected", startDate, endDate);

//		//WMS
//		Layer filterClickLayer = OpenLayers.createInteractiveFilterLayerWMS("http://dionysus.di.uoa.gr:8080/geoserver/wms", "opengeo" , "animalia_fishbase_10000only", "layerSlider",  "datecollected", startDate, endDate);
//		map.addLayer(filterClickLayer);
//		Control featureControl = OpenLayers.createWMSFeatureControl(filterClickLayer);
//		map.addControl(featureControl);
//		//WMS_2
		Layer filterClickLayer2 = OpenLayers.createInteractiveFilterLayerWMS("http://dionysus.di.uoa.gr:8080/geoserver/wms", "opengeo" , "animalia_fishbase_5mostcommon_nn", "layerSlider",  "datecollected", startDate, endDate);
//		Layer filterClickLayer2 = OpenLayers.createInteractiveFilterLayerWMS("http://dionysus.di.uoa.gr:8080/geoserver/wms", "opengeo" , "animalia_fishbase_lim_5000", "layerSlider",  "datecollected", startDate, endDate);
//		Layer filterClickLayer2 = OpenLayers.createInteractiveFilterLayerWMS("http://dionysus.di.uoa.gr:8080/geoserver/wms", "opengeo" , "animalia_fishbase_nn_sql", "layerSlider",  "datecollected", startDate, endDate);
		map.addLayer(filterClickLayer2);
		Control featureControl2 = OpenLayers.createWMSFeatureControl(filterClickLayer2, VisualisationTypes.allWMS());
		map.addControl(featureControl2);
		
		//WMS_countries
//		Layer chloropleth = OpenLayers.createInteractiveCatchLayer("http://dionysus.di.uoa.gr:8080/geoserver/wms", "http://dionysus.di.uoa.gr:8080/geoserver/wfs", "opengeo" , "countries_very_simple", "opengeo" , "fisheries", "layerSlider1",  "country", 1950 , 2010);
//		map.addLayer(chloropleth);
		
		
		//WFS
		Layer filterClickLayer = OpenLayers.createInteractiveFilterLayerWFS("http://dionysus.di.uoa.gr:8080/geoserver/wfs", "opengeo" , "animalia_fishbase_clupea_harengus", "layerSlider",  "datecollected", startDate, endDate);
//		Layer filterClickLayer = OpenLayers.createInteractiveFilterLayerWFS("http://dionysus.di.uoa.gr:8080/geoserver/wfs", "opengeo" , "animalia_fishbase_3mostcommon", "layerSlider",  "datecollected", startDate, endDate);
		map.addLayer(filterClickLayer);
		Control featureControl = OpenLayers.createWFSFeatureControl(filterClickLayer, VisualisationTypes.allWMF());
		map.addControl(featureControl);

		RootPanel.get().add(mapWidget);
		
		
	}



}
