var layer;

function createWFSFeatureControl(layerObject, visualisationTypes){


	// show all control panel elements
	var panelChild, children = layerObject.div.children;
	for(var i=0;i<children.length;i++){
		var current = $(children[i]);
		if(current.attr("id")==undefined)
			continue;
		current.children().show();
		panelChild = current;
	}
	
	//add a control on the map for this layer
	var multiSelect = new OpenLayers.Control.SelectFeature(layerObject, {
		clickout : true,
		toggle : false,
		multiple : true,
		hover : false,
		highlightOnly: false,
		// toggleKey: "ctrlKey", // ctrl key removes from selection
		multipleKey : "shiftKey", // shift key adds to selection
		box : true
	});
	
	
//  multiSelect.events.register("featureunhighlighted",this, function() {console.log("beforefeaturesselected")});
//	multiSelect.events.register("beforefeaturehighlighted", this, function (e) {visualiseFeatures(e)});
//	multiSelect.events.register("boxselectionstart", this, function (e) {console.log("boxselectionstart")});
//	multiSelect.events.register("featurehighlighted", this, function (e) {featurehighlighted(e)});
	
	
	multiSelect.deactivate();
	layerObject.map.addControl(multiSelect);
	
	//when layer removed from map, destroy its accompanying Control.SelectFeature  
//	layerObject.removeMap(function(map){
//		map.removeControl(multiSelect);
//	});
	
	
	//add a callback on change of the drop-down menu to switch selection mode and initiate the popup with the ribbon !
	var panelSelector = panelChild.find('select');
	panelSelector.change(function(evt){
			if(panelSelector.val()=="nav")
				multiSelect.deactivate();
			else
				multiSelect.activate();
		}
	);
	//also deactivate when layer is deactivated (that's important)
	layerObject.events.register("visibilitychanged", layerObject, function(){multiSelect.deactivate();});
	
	
	multiSelect.events.register("boxselectionend", this, function (e) {
		panelSelector.val('nav');
		multiSelect.deactivate();
		visualiseFeatures(e,multiSelect, visualisationTypes);
		
	});	
	
	layerObject.multiselectID = multiSelect.id; //just to know the id
	
	return multiSelect;
}

function visualiseFeatures(e,multiSelect, visualisationTypes) {
	switch(e.layers[0].selectedFeatures.length)
	{
	case 0:
//		console.log("none selected");
	  return;
	case 1:
	  visualiseSingle(e,multiSelect);
	  break;
	default:
	  visualiseMultiple(e,multiSelect,visualisationTypes);
	}
	
	
}

function visualiseSingle(e,multiSelect) {
	console.log("visualiseSingle");
}

function visualiseMultiple(e,multiSelect,visualisationTypes) {
	console.log("visualiseMultiple");
	//create jQuery popup selection panel
	var tempUL = $('<ul/>', {
	    id: 'tempMenu'
	});
	//the optionsArray is the visualisationTypes which come from initiation of the whole class.
//	var optionsArray = new Array();
//	optionsArray.push("Timeline");
//	optionsArray.push("Option2");
//	optionsArray.push("Cancel");
	var optionsArray = visualisationTypes.split(',');
	for(var option in optionsArray){
		var tempLI = $('<li/>', {}).appendTo(tempUL);
		$('<a/>',{
//			href:"#",
			text: optionsArray[option]
		}).appendTo(tempLI);
	}

	
	//create the popup to hold the selection panel
	var tempPopup = new OpenLayers.Popup("popupMenu",
			e.object.map.getLonLatFromPixel(
					e.object.map.getControl("olControlMousePosition")!=null ?
							e.object.map.getControl("olControlMousePosition").lastXy : 
							 {x : e.object.map.getSize().w/2,y : e.object.map.getSize().h/2}	
			),
            new OpenLayers.Size(50,50),
            "",
            false
    );
	tempPopup.setBackgroundColor("transparent");
	e.object.map.addPopup(tempPopup);
	tempPopup.addCloseBox(function(){
		tempPopup.destroy();
	});
	
	var menu = $(tempUL).menu();
	$(tempPopup.contentDiv).append(tempUL);
	tempPopup.updateSize();
	
	menu.on( "menuselect", function( event, ui ) {
		$(menu).parent().parent().parent().remove();
		switch(ui.item.text())
		{
		case "Timeline":
			ribbonVisualisation(e,multiSelect);
			multiSelect.unselectAll();
			break;
		}
		
		
	});
	
}


function bestRibbonPopupPosition(mapSize,popupSize){
	return {x:(mapSize.w-popupSize.w)/2,y:mapSize.h-popupSize.h-1};
	//line below is for output in middle of map
//	return {x:(mapSize.w-popupSize.w)/2,y:(mapSize.h-popupSize.h)/2};
}

function ribbonVisualisation(e,multiSelect){

	var popupSize = new OpenLayers.Size(e.object.map.getSize().w-80,e.object.map.getSize().h/8);
	var bestPosition = bestRibbonPopupPosition(e.object.map.getSize() ,popupSize);
	
	var popup = new OpenLayers.Popup("VisualisationPopup",
		e.object.map.getLonLatFromPixel(bestPosition),
		popupSize,
	    "",
	    false
	);
	e.object.map.addPopup(popup);
	popup.panIntoView();
	popup.padding = 20;
	
	e.layers[0].events.register("move",this,function(){
		popup.lonlat = e.object.map.getLonLatFromPixel(bestPosition);
		popup.updatePosition();
		console.log("popup.updatePosition(); -- move");
	});
	
	e.layers[0].events.register("moveend",this,function(){
		popup.lonlat = e.object.map.getLonLatFromPixel(bestPosition);
		popup.updatePosition();
		console.log("popup.updatePosition(); -- moveend");
	});
	
	
	popup.addCloseBox(function(){
		popup.destroy();
	});
	
	
	//this fixes the overflow problem
	$(popup.contentDiv).css({ 'overflow': 'hidden'});
	//this fixes thelayer.map.getControl(layer.multiselectID) close button visibility
	$(popup.closeDiv).css({ 'z-index': $(popup.groupDiv).parent().css("z-index")});
	
//	var height = $(popup.contentDiv).height();
//	var width = $(popup.contentDiv).width();
//	var boxWidth = $(popup.contentDiv).parent().children('.olPopupCloseBox').width();
		
    var tl_el = $(popup.contentDiv)[0];
    var eventSource1 = new Timeline.DefaultEventSource();
    
    var theme1 = Timeline.ClassicTheme.create();
    theme1.timeline_start = new Date(e.object.layer.getSliderValues()[0]);//new Date(Date.UTC(1890, 0, 1));
    theme1.timeline_stop  = new Date(e.object.layer.getSliderValues()[1]);//new Date(Date.UTC(2160, 0, 1));
    
    var d = Timeline.DateTime.parseGregorianDateTime("1900");
    var bandInfos = [
		Timeline.createBandInfo({
		    width:          "70%", 
		    intervalUnit:   Timeline.DateTime.YEAR,
		    eventSource:    eventSource1,
		    date:           d,
		    theme:          theme1,
		    intervalPixels: 100,
		    layout:         'original'  // original, overview, detailed
		}),
		Timeline.createBandInfo({
		    width:          "30%",
		    intervalUnit:   Timeline.DateTime.DECADE, 
		    intervalPixels: 200
		})
	];
	bandInfos[1].syncWith = 0;
	bandInfos[1].highlight = true;
	
		   
    // create the Timeline
    var tl = Timeline.create(tl_el, bandInfos, Timeline.HORIZONTAL);
    
    eventSource1.loadJSON(ribbonDataTransform(e),"."); 
    
    tl.layout(); // display the Timeline
    
	//remove the timeline (well, don't know if that's legit)
    $(tl_el).find(".timeline-copyright").remove();
    
}

function ribbonDataTransform(e) {
	
    var timeline_data = {
    	dateTimeFormat: 'Gregorian'
    }
    
    var clustered; //if results are clustered or not
    e.layers[0].selectedFeatures[0]['cluster'] != undefined ? clustered=true : clustered=false;
	
	var events = Array();
	
	if(clustered){
		for(var cl=0;cl<e.layers[0].selectedFeatures.length;cl++){ //selected features are actually the selected clusters in clustering mode
			for(var i=0;i<e.layers[0].selectedFeatures[cl].cluster.length;i++){ //go through the clusters and their containing features
				var f = e.layers[0].selectedFeatures[cl].cluster[i];
				var callback = "gotoclicked("+f.attributes.id+");"
				events.push({
					start: f.attributes.datecollected,
					description: "<a onclick='"+callback+"'>Show within map</a>",
					title: f.attributes.sname+"--"+f.attributes.tauthor
				});
			}
		}
	}else{
		for(var i=0;i<e.layers[0].selectedFeatures.length;i++){//feature in e.layers[0].selectedFeatures){
			var f = e.layers[0].selectedFeatures[i];
			var callback = "gotoclicked("+f.attributes.id+");"
			events.push({
				start: f.attributes.datecollected,
				description: "<a onclick='"+callback+"'>Show within map</a>",
				title: f.attributes.sname+"--"+f.attributes.tauthor
			});
		}
	}
	
	
	layer = e.layers[0];  //that's the only way to keep the object and call it later asynchronously !
	
    timeline_data.events = events;
    
	return timeline_data;//JSON.stringify(timeline_data);
	
}

function gotoclicked(featureId){
	console.log("gotoclicked: " + featureId);
	
    var clustered; //if results are clustered or not
    layer.features[0]['cluster'] != undefined ? clustered=true : clustered=false;
	
    if(clustered){
    	for(var cl=0;cl<layer.features.length;cl++){ //selected features are actually the selected clusters in clustering mode
			for(var i=0;i<layer.features[cl].cluster.length;i++){ //go through the clusters and their containing features
				if(layer.features[cl].cluster[i].data.id==featureId){
					console.log("found id " + featureId + "at position (cluster,item): (" +cl+","+i+")");
					layer.map.setCenter(new OpenLayers.LonLat(layer.features[cl].cluster[i].data.longitude, layer.features[cl].cluster[i].data.latitude),Math.ceil(layer.map.numZoomLevels/2));
					layer.map.getControl(layer.multiselectID).unselectAll();
					var cluster = findFeatureClusterInClusteredFeatures(layer,featureId).cluster;
					layer.map.getControl(layer.multiselectID).select(layer.features[cluster]);
					break;
				}
			}
    	}
    }else{
		for(var i=0;i<layer.features.length;i++){
			if(layer.features[i].data.id==featureId){
	//			console.log("found id " + featureId + "at position: " + i);
				//go to the feature location (location,zoom)
				layer.map.setCenter(new OpenLayers.LonLat(layer.features[i].data.longitude, layer.features[i].data.latitude),layer.map.zoom);	
				//unselect all features -- maybe considering removing this later on if it breaks the user interface
				layer.map.getControl(layer.multiselectID).unselectAll();
				//and select the one above
				layer.map.getControl(layer.multiselectID).select(layer.features[i]);
				break;
			}
		}
    }
}

function findFeatureClusterInClusteredFeatures(layer, featureId){
	for(var cl=0;cl<layer.features.length;cl++)
		for(var i=0;i<layer.features[cl].cluster.length;i++)
			if(layer.features[cl].cluster[i].data.id==featureId)
				return {"cluster":cl,"pos":i};
	return ;
}

