function doCumulativeVisualise(cumulativeVisData, divID, width, height){
	
	nv.addGraph(function() {
		var chart = nv.models.cumulativeLineChart()
		.x(function(d) { return d[0]; })
		.y(function(d) { return d[1]; }) 
		.color(d3.scale.category20().range());
		
		chart.xAxis.axisLabel('Date')
		.tickFormat(function(d) {
		 return d3.time.format('%Y')(new Date(d))
		});
		
		chart.yAxis.axisLabel('Cumulative Observations')
		.tickFormat(d3.format(',d'));
		
		d3.select("#"+divID)
		.append('svg')
		.datum(cumulativeVisData)
//		.transition().duration(500)
		.call(chart);
		
		//TODO: Figure out a good way to do this automatically
		//we currently use a non-resizable popup, so done once is just enough
		nv.utils.windowResize(chart.update);
		
//		return chart;
	});
}



