/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.DataModel;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@XStreamAlias(value="Field")
@XmlRootElement(namespace="http://gcube-system.org/namespaces/application/aquamaps/types")
public class Field
extends DataModel
implements Comparable<Field> {
    public static final String VOID = "VOID";
    @XmlElement(namespace="http://gcube-system.org/namespaces/application/aquamaps/types")
    @XStreamAsAttribute
    private FieldType type = FieldType.STRING;
    @XmlElement(namespace="http://gcube-system.org/namespaces/application/aquamaps/types")
    @XStreamAsAttribute
    private String name;
    @XmlElement(namespace="http://gcube-system.org/namespaces/application/aquamaps/types")
    @XStreamAsAttribute
    private String value;

    public FieldType type() {
        return this.type;
    }

    public Field() {
        this.type = FieldType.STRING;
        this.name = "DefaultFieldName";
        this.value = "DefaultValue";
    }

    public Field(String name, String value) {
        this();
        this.name = name;
        this.value = value;
    }

    public Field(String name, String value, FieldType type) {
        this(name, value);
        this.type(type);
    }

    public void type(FieldType type) {
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public String value() {
        return this.value;
    }

    public void value(String value) {
        this.value = value;
    }

    public String getOperator() {
        if (this.name.contains("min")) {
            return ">=";
        }
        if (this.name.contains("max")) {
            return "<=";
        }
        return "=";
    }

    public static List<Field> loadRow(ResultSet rs) throws Exception {
        ArrayList<Field> toReturn = new ArrayList<Field>();
        ResultSetMetaData rsMeta = rs.getMetaData();
        int colCount = rsMeta.getColumnCount();
        int i = 1;
        while (i <= colCount) {
            toReturn.add(new Field(rsMeta.getColumnName(i), rs.getString(i), Field.getType(rsMeta.getColumnType(i))));
            ++i;
        }
        return toReturn;
    }

    public static FieldType getType(int SQLType2) {
        if (SQLType2 == 92 || SQLType2 == 93) {
            return FieldType.TIMESTAMP;
        }
        if (SQLType2 == -5 || SQLType2 == -6 || SQLType2 == 5 || SQLType2 == 4 || SQLType2 == -7) {
            return FieldType.INTEGER;
        }
        if (SQLType2 == 6 || SQLType2 == 8 || SQLType2 == 7 || SQLType2 == 3 || SQLType2 == 2) {
            return FieldType.DOUBLE;
        }
        if (SQLType2 == 16) {
            return FieldType.BOOLEAN;
        }
        return FieldType.STRING;
    }

    public static List<List<Field>> loadResultSet(ResultSet rs) throws SQLException {
        ArrayList<List<Field>> toReturn = new ArrayList<List<Field>>();
        ResultSetMetaData rsMeta = rs.getMetaData();
        int colCount = rsMeta.getColumnCount();
        while (rs.next()) {
            ArrayList<Field> row = new ArrayList<Field>();
            int i = 1;
            while (i <= colCount) {
                row.add(new Field(rsMeta.getColumnName(i), rs.getString(i), Field.getType(rsMeta.getColumnType(i))));
                ++i;
            }
            toReturn.add(row);
        }
        return toReturn;
    }

    public Double getValueAsDouble() {
        if (this.isNull()) {
            return null;
        }
        return Double.parseDouble(this.value());
    }

    public Integer getValueAsInteger() {
        if (this.isNull()) {
            return null;
        }
        return Integer.parseInt(this.value());
    }

    public Long getValueAsLong() {
        if (this.isNull()) {
            return null;
        }
        return Long.parseLong(this.value());
    }

    public Boolean getValueAsBoolean() {
        if (this.isNull()) {
            return null;
        }
        try {
            Integer i = this.getValueAsInteger();
            return i.equals(1);
        }
        catch (Exception e) {
            return Boolean.parseBoolean(this.value());
        }
    }

    public boolean isNull() {
        return this.value() == null || this.value().equals(VOID) || this.value().equals("") || this.value().equals(" ") || this.value().equalsIgnoreCase("null");
    }

    public boolean validate() {
        if (this.isNull()) {
            return true;
        }
        try {
            switch (this.type()) {
                case BOOLEAN: {
                    this.getValueAsBoolean();
                    break;
                }
                case DOUBLE: {
                    this.getValueAsDouble();
                    break;
                }
                case INTEGER: {
                    this.getValueAsInteger();
                    break;
                }
                case LONG: {
                    this.getValueAsLong();
                }
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Double getValueAsDouble(String defaultValue) {
        try {
            return Double.parseDouble(this.value());
        }
        catch (Exception e) {
            return Double.parseDouble(defaultValue);
        }
    }

    public Integer getValueAsInteger(String defaultValue) {
        try {
            return Integer.parseInt(this.value());
        }
        catch (Exception e) {
            return Integer.parseInt(defaultValue);
        }
    }

    public Long getValueAsLong(String defaultValue) {
        try {
            return Long.parseLong(this.value());
        }
        catch (Exception e) {
            return Long.parseLong(defaultValue);
        }
    }

    public Boolean getValueAsBoolean(String defaultValue) {
        try {
            return Boolean.parseBoolean(this.value());
        }
        catch (Exception e) {
            Integer i = this.getValueAsInteger();
            if (i != null) {
                return i == 1;
            }
            return Boolean.parseBoolean(defaultValue);
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject toReturn = new JSONObject();
        toReturn.put("name", (Object)this.name);
        toReturn.put("value", (Object)this.value);
        toReturn.put("type", (Object)this.type);
        return toReturn;
    }

    public Field(JSONObject obj) throws JSONException {
        this.name(obj.getString("name"));
        this.type(FieldType.valueOf(obj.getString("type")));
        this.value(obj.getString("value"));
    }

    public static ArrayList<Field> fromJSONArray(JSONArray array) throws JSONException {
        ArrayList<Field> toReturn = new ArrayList<Field>();
        int i = 0;
        while (i < array.length()) {
            toReturn.add(new Field(array.getJSONObject(i)));
            ++i;
        }
        return toReturn;
    }

    public static JSONArray toJSONArray(List<Field> list) throws JSONException {
        JSONArray array = new JSONArray();
        for (Field f : list) {
            array.put((Object)f.toJSONObject());
        }
        return array;
    }

    @Override
    public int compareTo(Field arg0) {
        return this.name().compareTo(arg0.name());
    }

    public String toString() {
        return "Field [type=" + (Object)((Object)this.type) + ", name=" + this.name + ", value=" + this.value + "]";
    }
}

