package org.gcube.application.aquamaps.dataModel.enhanced;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import org.gcube.application.aquamaps.dataModel.Types.FieldType;
import org.gcube.application.aquamaps.dataModel.Types.ObjectType;
import org.gcube.application.aquamaps.dataModel.Types.SubmittedStatus;
import org.gcube.application.aquamaps.dataModel.fields.SubmittedFields;
import org.gcube.application.aquamaps.dataModel.utils.CSVUtils;

public class Submitted extends DataModel{


	private Integer searchId;
	private String title;
	private String author;
	private Integer jobId;
	private String selectionCriteria;
	private SubmittedStatus status=SubmittedStatus.Pending;
	private ObjectType type;
	private Boolean isAquaMap;
	private Boolean saved;
	private Integer sourceHCAF;
	private Integer sourceHSPEN;
	private Integer sourceHSPEC;
	private Boolean gisEnabled;
	private List<String> gisPublishedId=new ArrayList<String>();
	private List<String> gisReferences=new ArrayList<String>();
	private String serializedPath;
	private Long startTime=0l;
	private Long endTime=0l;
	private Long submissionTime=0l;
	private Boolean postponePublishing;

	public Long getStartTime() {
		return startTime;
	}


	public void setStartTime(Long startTime) {
		this.startTime = startTime;
	}


	public Long getEndTime() {
		return endTime;
	}


	public void setEndTime(Long endTime) {
		this.endTime = endTime;
	}


	public Long getSubmissionTime() {
		return submissionTime;
	}


	public void setSubmissionTime(Long submissionTime) {
		this.submissionTime = submissionTime;
	}




	@Deprecated
	public Submitted(Integer searchId){
		this.setSearchId(searchId);
	}


	public Integer getSearchId() {
		return searchId;
	}
	public void setSearchId(Integer searchId) {
		this.searchId = searchId;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getAuthor() {
		return author;
	}
	public void setAuthor(String author) {
		this.author = author;
	}
	public Integer getJobId() {
		return jobId;
	}
	public void setJobId(Integer jobId) {
		this.jobId = jobId;
	}
	public String getSelectionCriteria() {
		return selectionCriteria;
	}
	public void setSelectionCriteria(String selectionCriteria) {
		this.selectionCriteria = selectionCriteria;
	}
	public SubmittedStatus getStatus() {
		return status;
	}
	public void setStatus(SubmittedStatus status) {
		this.status = status;
	}
	public ObjectType getType() {
		return type;
	}
	public void setType(ObjectType type) {
		this.type = type;
	}
	public Boolean getIsAquaMap() {
		return isAquaMap;
	}
	public void setIsAquaMap(Boolean isAquaMap) {
		this.isAquaMap = isAquaMap;
	}
	public Boolean getSaved() {
		return saved;
	}
	public void setSaved(Boolean saved) {
		this.saved = saved;
	}
	public Integer getSourceHCAF() {
		return sourceHCAF;
	}
	public void setSourceHCAF(Integer sourceHCAF) {
		this.sourceHCAF = sourceHCAF;
	}
	public Integer getSourceHSPEN() {
		return sourceHSPEN;
	}
	public void setSourceHSPEN(Integer sourceHSPEN) {
		this.sourceHSPEN = sourceHSPEN;
	}
	public Integer getSourceHSPEC() {
		return sourceHSPEC;
	}
	public void setSourceHSPEC(Integer sourceHSPEC) {
		this.sourceHSPEC = sourceHSPEC;
	}

	public static ArrayList<Submitted> loadResultSet(ResultSet rs)throws Exception{
		ArrayList<Submitted> toReturn=new ArrayList<Submitted>();
		while(rs.next()){
			toReturn.add(new Submitted(Field.loadRow(rs)));
		}
		return toReturn;
	}


	public Submitted (org.gcube.application.aquamaps.dataModel.Submitted toLoad){
		super();
		this.author=toLoad.getAuthor();
		setSubmissionTime(toLoad.getSubmissionTime());
		setEndTime(toLoad.getEndTime());
		setStartTime(toLoad.getStartTime());
		this.isAquaMap=toLoad.isIsAquaMap();
		this.jobId=toLoad.getJobId();
		this.saved=toLoad.isSaved();
		this.searchId=toLoad.getSearchId();
		this.selectionCriteria=toLoad.getSelectionCriteria();
		this.sourceHCAF=toLoad.getSourceHCAF();
		this.sourceHSPEC=toLoad.getSourceHSPEC();
		this.sourceHSPEN=toLoad.getSourceHSPEN();
		this.status=SubmittedStatus.valueOf(toLoad.getStatus());
		this.title=toLoad.getTitle();
		this.type=((toLoad.getType()!=null)&&(!toLoad.getType().equalsIgnoreCase("null")))?ObjectType.valueOf(toLoad.getType()):null;

		this.gisReferences=CSVUtils.CSVToList(toLoad.getGisReferences());
		this.gisPublishedId=CSVUtils.CSVToList(toLoad.getPublishedIds());
		this.setGisEnabled(toLoad.isGisEnabled());
	}

	public org.gcube.application.aquamaps.dataModel.Submitted toStubsVersion(){
		org.gcube.application.aquamaps.dataModel.Submitted toReturn=new org.gcube.application.aquamaps.dataModel.Submitted();
		toReturn.setAuthor(author);
		toReturn.setSubmissionTime(submissionTime);
		toReturn.setEndTime(endTime);
		toReturn.setStartTime(startTime);
		toReturn.setGisEnabled(gisEnabled);
		toReturn.setIsAquaMap(isAquaMap);
		toReturn.setJobId(jobId);
		toReturn.setSaved(saved);
		toReturn.setSearchId(searchId);
		toReturn.setSelectionCriteria(selectionCriteria);
		toReturn.setSourceHCAF(sourceHCAF);
		toReturn.setSourceHSPEC(sourceHSPEC);
		toReturn.setSourceHSPEN(sourceHSPEN);
		toReturn.setStatus(status+"");
		toReturn.setTitle(title);
		toReturn.setType(type+"");
		toReturn.setGisReferences(CSVUtils.listToCSV(gisReferences));
		toReturn.setPublishedIds(CSVUtils.listToCSV(gisPublishedId));
		return toReturn;		
	}

	private Submitted(){};
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
		+ ((searchId == null) ? 0 : searchId.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Submitted other = (Submitted) obj;
		if (searchId == null) {
			if (other.searchId != null)
				return false;
		} else if (!searchId.equals(other.searchId))
			return false;
		return true;
	}

	public void setGisEnabled(Boolean gisEnabled) {
		this.gisEnabled = gisEnabled;
	}

	public Boolean getGisEnabled() {
		return gisEnabled;
	}

	public void setGisPublishedId(List<String> gisPublishedId) {
		this.gisPublishedId = gisPublishedId;
	}

	public List<String> getGisPublishedId() {
		return gisPublishedId;
	}

	public void setGisReferences(List<String> gisReferences) {
		this.gisReferences = gisReferences;
	}

	public List<String> getGisReferences() {
		return gisReferences;
	}


	public void setSerializedPath(String serializedPath) {
		this.serializedPath = serializedPath;
	}


	public String getSerializedPath() {
		return serializedPath;
	}

	
	public Boolean getPostponePublishing() {
		return postponePublishing;
	}


	public void setPostponePublishing(Boolean postponePublishing) {
		this.postponePublishing = postponePublishing;
	}


	public Submitted(ResultSet rs)throws Exception{
		this(Field.loadRow(rs));
	}
	public Submitted(List<Field> row){
		for(Field f: row)	
			try{
				this.setField(f);
			}catch(Exception e){
				//skips wrong fields
			}
	}

	public boolean setField(Field f){
		switch(SubmittedFields.valueOf(f.getName().toLowerCase())){
		case searchid: this.setSearchId(f.getValueAsInteger());
		break;
		case title: this.setTitle(f.getValue());
		break;
		case author: this.setAuthor(f.getValue());
		break;
		case endtime : this.setEndTime(Long.parseLong(f.getValue()));
		break;
		case geoserverreference : this.setGisReferences(CSVUtils.CSVToList(f.getValue()));
		break;
		case gisenabled : this.setGisEnabled(f.getValueAsBoolean());
		break;
		case gispublishedid : this.setGisPublishedId(CSVUtils.CSVToList(f.getValue()));
		break;
		case isaquamap : this.setIsAquaMap(f.getValueAsBoolean());
		break;
		case jobid : this.setJobId(f.getValueAsInteger());
		break;
		case saved : this.setSaved(f.getValueAsBoolean());
		break;
		case selectioncriteria : this.setSelectionCriteria(f.getValue());
		break;
		case serializedpath : this.setSerializedPath(f.getValue());
		break;
		case postponepublishing: this.setPostponePublishing(f.getValueAsBoolean());
		break;
		case sourcehcaf : this.setSourceHCAF(f.getValueAsInteger());
		break;
		case sourcehspen: this.setSourceHSPEN(f.getValueAsInteger());
		break;
		case sourcehspec: this.setSourceHSPEC(f.getValueAsInteger());
		break;
		case status : this.setStatus(SubmittedStatus.valueOf(f.getValue()));
		break;
		case type:this.setType(ObjectType.valueOf(f.getValue()));
		break;
		case starttime : this.setStartTime(Long.parseLong(f.getValue()));
		break;
		case submissiontime : this.setSubmissionTime(Long.parseLong(f.getValue()));
		break;
		default : return false;
		}
		return true;
	}

	public Field getField(SubmittedFields fieldName){
		switch(fieldName){
		case searchid: return new Field(fieldName+"",getSearchId()+"",FieldType.INTEGER);
		case title: return new Field(fieldName+"",getTitle(),FieldType.STRING);
		case author : 	return new Field(fieldName+"",getAuthor(),FieldType.STRING);
		case endtime : return new Field(fieldName+"",getEndTime()+"",FieldType.INTEGER);
		case starttime: return new Field(fieldName+"",getStartTime()+"",FieldType.INTEGER);
		case submissiontime : return new Field(fieldName+"",getSubmissionTime()+"",FieldType.INTEGER);
		case geoserverreference : return new Field(fieldName+"",CSVUtils.listToCSV(getGisReferences()),FieldType.STRING);
		case gisenabled : return new Field(fieldName+"",(getGisEnabled()?1:0)+"",FieldType.INTEGER);
		case gispublishedid: return new Field(fieldName+"",CSVUtils.listToCSV(getGisPublishedId()),FieldType.STRING);
		case isaquamap: return new Field(fieldName+"",(getIsAquaMap()?1:0)+"",FieldType.INTEGER);
		case jobid: return new Field(fieldName+"",getJobId()+"",FieldType.INTEGER);
		case saved: return new Field(fieldName+"",(getSaved()?1:0)+"",FieldType.INTEGER);
		case selectioncriteria: return new Field(fieldName+"",getSelectionCriteria()+"",FieldType.STRING);
		case serializedpath: return new Field(fieldName+"",getSerializedPath(),FieldType.STRING);
		case postponepublishing:return new Field(fieldName+"",getPostponePublishing()+"",FieldType.BOOLEAN);
		case sourcehcaf : return new Field(fieldName+"",getSourceHCAF()+"",FieldType.INTEGER);
		case sourcehspen: return new Field(fieldName+"",getSourceHSPEN()+"",FieldType.INTEGER);
		case sourcehspec: return new Field(fieldName+"",getSourceHSPEC()+"",FieldType.INTEGER);
		case status : return new Field(fieldName+"",getStatus()+"",FieldType.STRING);
		case type: return new Field(fieldName+"",getType()+"",FieldType.STRING);
		default : return null;

		}
	}

	public List<Field> toRow(){
		List<Field> toReturn= new ArrayList<Field>();
		for(SubmittedFields f : SubmittedFields.values())
			toReturn.add(getField(f));
		return toReturn;
	}
}
