/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.client.filters;

import com.allen_sauer.gwt.log.client.Log;
import com.gwtext.client.core.SortDir;
import com.gwtext.client.data.GroupingStore;
import com.gwtext.client.data.JsonReader;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.SortState;
import com.gwtext.client.data.Store;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.GridPanel;
import com.gwtext.client.widgets.grid.GridView;
import com.gwtext.client.widgets.grid.GroupingView;
import org.gcube.application.aquamaps.aquamapsportlet.client.RecordDefinitions;

public class FilterSummary
extends GridPanel {
    public static String CodeType = "Code";
    public static String NameType = "Name";
    public static String additional = "Additional Criteria";
    public static String Phylogeny = "Phylogeny";
    public static String MinMax = "MinMax";
    JsonReader reader;
    GroupingStore store;
    GroupingView gridView = new GroupingView();

    public FilterSummary() {
        this.setWidth(340);
        this.setHeight(300);
        this.setAutoScroll(true);
        this.setTitle("Active Filters Summary");
        this.setFrame(true);
        this.reader = new JsonReader(RecordDefinitions.perturbationRecordDef);
        this.reader.setRoot("data");
        this.reader.setTotalProperty("totalcount");
        this.store = new GroupingStore((Reader)this.reader);
        this.store.setGroupField("type");
        this.setStore((Store)this.store);
        this.setColumnModel(new ColumnModel((BaseColumnConfig[])new ColumnConfig[]{new ColumnConfig("Type", "type", 150, true), new ColumnConfig("Attribute", "attribute", 90, true), new ColumnConfig("Operator", "operator", 60, true), new ColumnConfig("Value", "value", 150, true)}));
        this.setStripeRows(true);
        this.store.setSortInfo(new SortState(RecordDefinitions.perturbationRecordDef.getFields()[0].getName(), SortDir.ASC));
        this.gridView.setEmptyText("No active Filters");
        this.gridView.setEmptyGroupText("No active filters of this kind");
        this.gridView.setEnableGrouping(true);
        this.gridView.setEnableGroupingMenu(false);
        this.gridView.setHideGroupedColumn(true);
        this.gridView.setStartCollapsed(true);
        this.gridView.setGroupTextTpl("{text} ({[values.rs.length]} {[values.rs.length > 1 ? \"Items\" : \"Item\"]})");
        this.setView((GridView)this.gridView);
    }

    public void addFilter(String type, String attribute, String operator, String value) {
        Record record = this.store.getById(type + attribute);
        if (record == null) {
            record = RecordDefinitions.filterRecordDef.createRecord(type + attribute, new Object[]{type, attribute, operator, value});
            this.store.add(record);
            Log.debug((String)"record added");
        } else {
            record.set("operator", operator);
            record.set("value", value);
            Log.debug((String)"record updated");
            this.store.commitChanges();
        }
        this.gridView.refresh();
    }

    public void removeFilter(String type, String attribute) {
        Record record = this.store.getById(type + attribute);
        if (record != null) {
            this.store.remove(record);
            Log.debug((String)"record removed");
            this.gridView.refresh();
        }
    }

    public void loadJSON(String data) {
        this.store.setGroupField("type");
        this.store.loadJsonData(data, false);
    }

    public String getJSON() {
        StringBuilder summary = new StringBuilder("{\"data\":[");
        for (Record r : this.store.getRecords()) {
            summary.append("{");
            String[] fieldNames = r.getFields();
            for (int i = 0; i < fieldNames.length; ++i) {
                summary.append("\"" + fieldNames[i] + "\":\"" + r.getAsString(fieldNames[i]) + "");
                if (i >= fieldNames.length - 1) continue;
                summary.append(",");
            }
            summary.append("}");
            if (this.store.indexOf(r) >= this.store.getRecords().length - 1) continue;
            summary.append(",");
        }
        summary.append("],\"totalcount\":" + this.store.getCount() + "}");
        return summary.toString();
    }
}

