/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.SpeciesFields;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.CustomServlet;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.Utils;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.PagedRequestSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.OrderDirection;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeciesServlet
extends CustomServlet {
    private static final long serialVersionUID = 5433023032821426866L;
    private static final Logger logger = LoggerFactory.getLogger(SpeciesServlet.class);

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.trace("SpeciesServlet-handleRequest");
        try {
            ASLSession session = Utils.getSession((HttpSession)request.getSession());
            StringBuilder sb = new StringBuilder();
            int startIndex = 0;
            int limit = 100;
            try {
                startIndex = Integer.parseInt(request.getParameter("start"));
                limit = Integer.parseInt(request.getParameter("limit"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            String sortColumn = request.getParameter("sort");
            String sortDir = request.getParameter("dir");
            if (sortColumn == null) {
                sortColumn = SpeciesFields.speciesid + "";
            }
            if (sortDir == null) {
                sortDir = "ASC";
            }
            try {
                List filter = (List)session.getAttribute("SPECIES_FILTER");
                int hspenId = (Integer)session.getAttribute(ResourceType.HSPEN + "");
                ScopeProvider.instance.set(session.getScope().toString());
                sb.append(((Maps)AbstractPlugin.maps().build()).getJSONSpecies(hspenId, null, filter, new PagedRequestSettings(limit, startIndex, sortColumn, OrderDirection.valueOf((String)sortDir))));
                response.setContentType("application/json; charset=utf-8");
                response.getWriter().write(sb.toString());
                response.setStatus(200);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.trace("Error from server", (Throwable)e);
                response.setStatus(500);
            }
        }
        catch (Exception e) {
            response.setStatus(401);
        }
    }
}

