/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientObject;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.Msg;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.SettingsDescriptor;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBInterface;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBManager;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.JSONUtils;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.Utils;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMapsObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Envelope;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Job;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Perturbation;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.EnvelopeFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.HspenFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ObjectType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    public static final String xmlHeader = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>";
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
    private static final String DEFAULT_USER = "fabio.sinibaldi";
    private static final String DEFAULT_SCOPE = "/gcube/devsec";

    public static String dateFormatter(Date time) {
        return sdf.format(time);
    }

    public static synchronized ASLSession getSession(HttpSession httpSession) throws Exception {
        String user = (String)httpSession.getAttribute("username");
        ASLSession toReturn = null;
        if (user == null) {
            toReturn = Utils.getDefaultSession((String)httpSession.getId());
        } else {
            String sessionID = httpSession.getId();
            toReturn = SessionManager.getInstance().getASLSession(sessionID, user);
        }
        try {
            logger.debug("Trying to initialize session for user : " + user);
            if (!toReturn.hasAttribute("showFao")) {
                toReturn.setAttribute("showFao", (Object)true);
            }
            if (!toReturn.hasAttribute("showLME")) {
                toReturn.setAttribute("showLME", (Object)false);
            }
            if (!toReturn.hasAttribute("showEEZ")) {
                toReturn.setAttribute("showEEZ", (Object)false);
            }
            if (!toReturn.hasAttribute("lastBasket")) {
                toReturn.setAttribute("lastBasket", new ArrayList());
            }
            if (!(toReturn.hasAttribute(ResourceType.HCAF + "") && toReturn.hasAttribute(ResourceType.HSPEC + "") && toReturn.hasAttribute(ResourceType.HSPEN + ""))) {
                for (Field f : ((DataManagement)AbstractPlugin.dataManagement().build()).getDefaultSources()) {
                    if (f.name().equals(ResourceType.HCAF + "")) {
                        toReturn.setAttribute(ResourceType.HCAF + "", (Object)f.getValueAsInteger());
                        continue;
                    }
                    if (f.name().equals(ResourceType.HSPEN + "")) {
                        toReturn.setAttribute(ResourceType.HSPEN + "", (Object)f.getValueAsInteger());
                        continue;
                    }
                    if (!f.name().equals(ResourceType.HSPEC + "")) continue;
                    toReturn.setAttribute(ResourceType.HSPEC + "", (Object)f.getValueAsInteger());
                }
            }
            logger.debug("Completed");
        }
        catch (Exception e) {
            logger.warn("Couldn't complete, probably session already existing");
        }
        return toReturn;
    }

    public static void addFetchedBasketId(ASLSession session, int objId) throws Exception {
        List fetchedBaskets = (List)session.getAttribute("lastBasket");
        if (!fetchedBaskets.contains(objId)) {
            fetchedBaskets.add(objId);
        }
        session.setAttribute("lastBasket", (Object)fetchedBaskets);
    }

    public static Envelope loadCustomizations(Envelope toUpdate, String speciesId, ASLSession session) throws Exception {
        logger.debug("Loading customization for psecies " + speciesId);
        Map perts = JSONUtils.JSONtoPert((String)DBManager.getInstance((String)session.getScope()).getPerturbation(speciesId, session.getUsername()));
        for (EnvelopeFields envField : EnvelopeFields.values()) {
            for (HspenFields hField : toUpdate.getValueNames(envField)) {
                if (!perts.containsKey(hField + "")) continue;
                Float value = Float.valueOf(Float.parseFloat(((Perturbation)perts.get(hField + "")).getPerturbationValue()));
                logger.debug("Setting customization " + envField + "," + hField + "," + value);
                toUpdate.setValue(envField, hField, (double)value.floatValue());
            }
        }
        return toUpdate;
    }

    public static Job loadSettings(ASLSession session, boolean fetchSpeciesIDs, boolean fetchResources) throws Exception {
        Job job = new Job();
        logger.debug("load settings..");
        ScopeProvider.instance.set(session.getScope().toString());
        DataManagement dm = (DataManagement)AbstractPlugin.dataManagement().build();
        if (fetchResources) {
            try {
                Integer hspenId = (Integer)session.getAttribute(ResourceType.HSPEN + "");
                Integer hspecId = (Integer)session.getAttribute(ResourceType.HSPEC + "");
                Integer hcafId = (Integer)session.getAttribute(ResourceType.HCAF + "");
                job.setSourceHSPEN(dm.loadResource(hspenId.intValue()));
                job.setSourceHSPEC(dm.loadResource(hspecId.intValue()));
                job.setSourceHCAF(dm.loadResource(hcafId.intValue()));
            }
            catch (Exception e) {
                logger.error("Unable to fetch resource details for job belonging to session : " + session.getUsername(), (Throwable)e);
            }
        }
        DBInterface db = DBManager.getInstance((String)session.getScope());
        job.getSelectedAreas().addAll(db.getAreaSelection(session.getUsername()));
        job.setAuthor(session.getUsername());
        if (fetchSpeciesIDs) {
            List speciesIds = db.getUserBasketIds(session.getUsername());
            for (String id : speciesIds) {
                Species toAdd = new Species(id);
                job.getSelectedSpecies().add(toAdd);
                Map speciesPerts = JSONUtils.JSONtoPert((String)db.getPerturbation(toAdd.getId(), session.getUsername()));
                if (speciesPerts == null || speciesPerts.isEmpty()) continue;
                job.getEnvelopeCustomization().put(toAdd.getId(), speciesPerts);
            }
        }
        for (ClientObject obj : db.getObjects(session.getUsername())) {
            AquaMapsObject toAdd = new AquaMapsObject();
            toAdd.setAuthor(session.getUsername());
            toAdd.setName(obj.getName());
            toAdd.getBoundingBox().parse(obj.getBoundingBox() + "");
            toAdd.setThreshold(obj.getThreshold().floatValue());
            toAdd.setType(ObjectType.valueOf((String)(obj.getType() + "")));
            toAdd.setGis(obj.getGis());
            toAdd.setAlgorithmType(job.getSourceHSPEC().getAlgorithm());
            if (toAdd.getType().equals((Object)ObjectType.Biodiversity)) {
                List ids = db.getObjectBasketIds(session.getUsername(), toAdd.getName());
                for (String id : ids) {
                    toAdd.getSelectedSpecies().add(new Species(id));
                }
            } else if (toAdd.getType().equals((Object)ObjectType.SpeciesDistribution)) {
                toAdd.getSelectedSpecies().add(new Species(obj.getSelectedSpecies().getValue()));
            }
            job.getAquaMapsObjectList().add(toAdd);
        }
        return job;
    }

    public static SettingsDescriptor getStats(Job job) throws Exception {
        int biodCount = 0;
        int distrCount = 0;
        boolean biodiversityBasketSizeCheck = true;
        for (AquaMapsObject obj : job.getAquaMapsObjectList()) {
            switch (1.$SwitchMap$org$gcube$application$aquamaps$aquamapsservice$stubs$fw$types$ObjectType[obj.getType().ordinal()]) {
                case 1: {
                    if (obj.getSelectedSpecies().size() < 2) {
                        biodiversityBasketSizeCheck = false;
                        logger.debug("Found invalid Biodiversity object " + obj.getName() + " size : " + obj.getSelectedSpecies().size());
                    }
                    ++biodCount;
                    break;
                }
                case 2: {
                    ++distrCount;
                }
            }
        }
        SettingsDescriptor toReturn = new SettingsDescriptor();
        toReturn.setBiodiversityObjectsCount(biodCount);
        toReturn.setCreateGroup(false);
        toReturn.setHspecId(job.getSourceHSPEC().getSearchId());
        toReturn.setHspecTitle(job.getSourceHSPEC().getTitle());
        toReturn.setNumberOfCustomizedSpecies(job.getEnvelopeCustomization().size());
        toReturn.setSelectedAreas(job.getSelectedAreas().size());
        toReturn.setSpeciesDistributionObjectCount(distrCount);
        toReturn.setSpeciesInBasket(job.getSelectedSpecies().size());
        toReturn.setToSubmitName(job.getName());
        if (job.getAquaMapsObjectList().size() == 0) {
            toReturn.setSubmittable(new Msg(false, "No AquaMaps objects to create"));
        } else if (!biodiversityBasketSizeCheck) {
            toReturn.setSubmittable(new Msg(false, "Biodiversity objects must be bound to at least 2 species"));
        } else if (toReturn.getToSubmitName() == null) {
            toReturn.setSubmittable(new Msg(false, "Please specify a title for this job"));
        } else {
            toReturn.setSubmittable(new Msg(true, "OK"));
        }
        return toReturn;
    }

    @Deprecated
    private static ASLSession getDefaultSession(String id) throws Exception {
        ASLSession toReturn = null;
        String sessionID = id;
        String user = "fabio.sinibaldi";
        toReturn = SessionManager.getInstance().getASLSession(sessionID, user);
        String scope = "/gcube/devsec";
        toReturn.setScope(scope);
        return toReturn;
    }

    public static Collection<String> getAvailableScopes() throws Exception {
        ArrayList<String> toReturn = new ArrayList<String>();
        String infrastructureScope = "/" + PortalContext.getConfiguration().getInfrastructureName();
        toReturn.add(infrastructureScope);
        for (String vo : PortalContext.getConfiguration().getVOs()) {
            toReturn.add(infrastructureScope + "/" + vo);
        }
        return toReturn;
    }

    public static String removeVRE(String currentScope) {
        if (currentScope.matches("/(.)*/(.)*/(.)*")) {
            return currentScope.substring(0, currentScope.lastIndexOf(47));
        }
        return currentScope;
    }
}

