/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMapsObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Area;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.DataModel;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Perturbation;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.EnvelopeFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ObjectType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube_system.namespaces.application.aquamaps.types.EnvelopeWeightArray;
import org.gcube_system.namespaces.application.aquamaps.types.EnvelopeWeights;
import org.gcube_system.namespaces.application.aquamaps.types.PerturbationArray;

public class Job
extends DataModel {
    private int id;
    private String name;
    private String author;
    private SubmittedStatus status = SubmittedStatus.Pending;
    private Long date = 0L;
    private List<AquaMapsObject> aquaMapsObjectList = new ArrayList<AquaMapsObject>();
    private Boolean isGis = false;
    private String wmsContextId;
    private Resource sourceHSPEN = new Resource(ResourceType.HSPEN, 1);
    private Resource sourceHCAF = new Resource(ResourceType.HCAF, 1);
    private Resource sourceHSPEC = new Resource(ResourceType.HSPEC, 1);
    private Set<Species> selectedSpecies = new TreeSet<Species>();
    private Map<String, Map<String, Perturbation>> envelopeCustomization = new HashMap<String, Map<String, Perturbation>>();
    private Map<String, Map<EnvelopeFields, Field>> envelopeWeights = new HashMap<String, Map<EnvelopeFields, Field>>();
    private Set<Area> selectedAreas = new HashSet<Area>();
    private List<File> related = new ArrayList<File>();

    public Job() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubmittedStatus getStatus() {
        return this.status;
    }

    public void setStatus(SubmittedStatus status) {
        this.status = status;
    }

    public Resource getSourceHSPEN() {
        return this.sourceHSPEN;
    }

    public void setSourceHSPEN(Resource sourceHSPEN) {
        this.sourceHSPEN = sourceHSPEN;
    }

    public Resource getSourceHCAF() {
        return this.sourceHCAF;
    }

    public void setSourceHCAF(Resource sourceHCAF) {
        this.sourceHCAF = sourceHCAF;
    }

    public Resource getSourceHSPEC() {
        return this.sourceHSPEC;
    }

    public void setSourceHSPEC(Resource sourceHSPEC) {
        this.sourceHSPEC = sourceHSPEC;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public int addSpecies(Collection<Species> toAdd) {
        this.selectedSpecies.addAll(toAdd);
        return this.selectedSpecies.size();
    }

    public int addAreas(Collection<Area> toAdd) {
        this.selectedAreas.addAll(toAdd);
        return this.selectedAreas.size();
    }

    public List<AquaMapsObject> getAquaMapsObjectList() {
        return this.aquaMapsObjectList;
    }

    public void setAquaMapsObjectList(List<AquaMapsObject> aquaMapsObjectList) {
        this.aquaMapsObjectList = aquaMapsObjectList;
    }

    public Set<Species> getSelectedSpecies() {
        return this.selectedSpecies;
    }

    public Map<String, Map<String, Perturbation>> getEnvelopeCustomization() {
        return this.envelopeCustomization;
    }

    public Set<Area> getSelectedAreas() {
        return this.selectedAreas;
    }

    public List<File> getRelated() {
        return this.related;
    }

    public void setRelated(List<File> related) {
        this.related = related;
    }

    public int removeAreas(Collection<Area> toRemove) {
        this.selectedAreas.removeAll(toRemove);
        return this.selectedAreas.size();
    }

    public int removeSpecies(Collection<Species> toAdd) {
        this.selectedSpecies.removeAll(toAdd);
        for (Species spec : toAdd) {
            this.envelopeWeights.remove(spec.getId());
            this.envelopeCustomization.remove(spec.getId());
        }
        for (AquaMapsObject obj : this.aquaMapsObjectList) {
            if (obj.getType().equals((Object)ObjectType.Biodiversity)) {
                int specsNumber = obj.removeSpecies(toAdd);
                if (specsNumber == 0) {
                    this.aquaMapsObjectList.remove(obj);
                    continue;
                }
                if (specsNumber != 1) continue;
                obj.setType(ObjectType.SpeciesDistribution);
                obj.setThreshold(0.0f);
                continue;
            }
            this.aquaMapsObjectList.remove(obj);
        }
        return this.selectedSpecies.size();
    }

    public int addAquaMapsObject(Collection<AquaMapsObject> toAdd) {
        this.aquaMapsObjectList.addAll(toAdd);
        return this.aquaMapsObjectList.size();
    }

    public int removeAquaMapsObject(Collection<AquaMapsObject> toRemove) {
        this.aquaMapsObjectList.removeAll(toRemove);
        return this.aquaMapsObjectList.size();
    }

    public AquaMapsObject addAquaMapsObject(ObjectType type) {
        AquaMapsObject toReturn = new AquaMapsObject();
        toReturn.setAuthor(this.author);
        toReturn.setType(type);
        this.aquaMapsObjectList.add(toReturn);
        return toReturn;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setEnvelopeWeights(Map<String, Map<EnvelopeFields, Field>> envelopeWeights) {
        this.envelopeWeights = envelopeWeights;
    }

    public Map<String, Map<EnvelopeFields, Field>> getEnvelopeWeights() {
        return this.envelopeWeights;
    }

    public Job(org.gcube_system.namespaces.application.aquamaps.types.Job toLoad) {
        String speciesID;
        int n;
        int n2;
        EnvelopeWeights[] envelopeWeightsArray;
        this.setAuthor(toLoad.getAuthor());
        this.setDate(toLoad.getDate());
        if (toLoad.getWeights() != null && toLoad.getWeights().getEnvelopeWeightList() != null) {
            envelopeWeightsArray = toLoad.getWeights().getEnvelopeWeightList();
            n2 = envelopeWeightsArray.length;
            n = 0;
            while (n < n2) {
                EnvelopeWeights weights = envelopeWeightsArray[n];
                speciesID = weights.getSpeciesId();
                if (!this.envelopeWeights.containsKey(speciesID)) {
                    this.envelopeWeights.put(speciesID, new HashMap());
                }
                for (Field f : Field.load(weights.getWeights())) {
                    this.envelopeWeights.get(speciesID).put(EnvelopeFields.valueOf(f.getName()), f);
                }
                ++n;
            }
        }
        if (toLoad.getEnvelopCustomization() != null && toLoad.getEnvelopCustomization().getPerturbationList() != null) {
            envelopeWeightsArray = toLoad.getEnvelopCustomization().getPerturbationList();
            n2 = envelopeWeightsArray.length;
            n = 0;
            while (n < n2) {
                EnvelopeWeights pert = envelopeWeightsArray[n];
                speciesID = pert.getToPerturbId();
                if (!this.envelopeCustomization.containsKey(speciesID)) {
                    this.envelopeCustomization.put(speciesID, new HashMap());
                }
                this.envelopeCustomization.get(speciesID).put(pert.getField(), new Perturbation((org.gcube_system.namespaces.application.aquamaps.types.Perturbation)pert));
                ++n;
            }
        }
        this.setRelated(File.load(toLoad.getRelatedResources()));
        this.setSelectedAreas(Area.load(toLoad.getSelectedAreas()));
        this.setId(toLoad.getId());
        this.setName(toLoad.getName());
        this.setSourceHCAF(new Resource(toLoad.getHcaf()));
        this.setSourceHSPEN(new Resource(toLoad.getHspen()));
        this.setSourceHSPEC(new Resource(toLoad.getHspec()));
        this.setStatus(SubmittedStatus.valueOf(toLoad.getStatus()));
        this.setAquaMapsObjectList(AquaMapsObject.load(toLoad.getAquaMapList()));
        this.getSelectedSpecies().addAll(Species.load(toLoad.getSelectedSpecies()));
        this.setIsGis(toLoad.isGis());
        this.setWmsContextId(toLoad.getGroupId());
    }

    public org.gcube_system.namespaces.application.aquamaps.types.Job toStubsVersion() throws JSONException {
        org.gcube_system.namespaces.application.aquamaps.types.Job toReturn = new org.gcube_system.namespaces.application.aquamaps.types.Job();
        toReturn.setAquaMapList(AquaMapsObject.toStubsVersion(this.getAquaMapsObjectList()));
        toReturn.setAuthor(this.getAuthor());
        toReturn.setDate(this.date != null ? this.date : 0L);
        ArrayList<org.gcube_system.namespaces.application.aquamaps.types.Perturbation> pertList = new ArrayList<org.gcube_system.namespaces.application.aquamaps.types.Perturbation>();
        for (String specId : this.envelopeCustomization.keySet()) {
            for (String field : this.envelopeCustomization.get(specId).keySet()) {
                Perturbation p = this.envelopeCustomization.get(specId).get(field);
                pertList.add(new org.gcube_system.namespaces.application.aquamaps.types.Perturbation(field, specId, p.getType().toString(), p.getPerturbationValue()));
            }
        }
        toReturn.setEnvelopCustomization(new PerturbationArray(pertList.toArray(new org.gcube_system.namespaces.application.aquamaps.types.Perturbation[pertList.size()])));
        toReturn.setHcaf(this.sourceHCAF.toStubsVersion());
        toReturn.setHspec(this.sourceHSPEC.toStubsVersion());
        toReturn.setHspen(this.sourceHSPEN.toStubsVersion());
        toReturn.setId(this.id);
        toReturn.setName(this.name);
        toReturn.setRelatedResources(File.toStubsVersion(this.related));
        toReturn.setSelectedAreas(Area.toStubsVersion(this.selectedAreas));
        toReturn.setSelectedSpecies(Species.toStubsVersion(this.selectedSpecies));
        toReturn.setStatus(this.status.toString());
        toReturn.setGis(this.isGis.booleanValue());
        toReturn.setGroupId(this.getWmsContextId());
        ArrayList<EnvelopeWeights> weightList = new ArrayList<EnvelopeWeights>();
        for (String specId : this.envelopeWeights.keySet()) {
            weightList.add(new EnvelopeWeights(specId, Field.toStubsVersion(this.envelopeWeights.get(specId).values())));
        }
        toReturn.setWeights(new EnvelopeWeightArray(weightList.toArray(new EnvelopeWeights[weightList.size()])));
        return toReturn;
    }

    public void setSelectedSpecies(Set<Species> selectedSpecies) {
        this.selectedSpecies = selectedSpecies;
    }

    public void setEnvelopeCustomization(Map<String, Map<String, Perturbation>> envelopeCustomization) {
        this.envelopeCustomization = envelopeCustomization;
    }

    public void setSelectedAreas(Set<Area> selectedAreas) {
        this.selectedAreas = selectedAreas;
    }

    public void setCustomization(Species s, Field f, Perturbation p) {
        Map<String, Perturbation> map = this.envelopeCustomization.get(s.getId());
        if (map == null) {
            map = new HashMap<String, Perturbation>();
        }
        map.put(f.getName(), p);
        this.envelopeCustomization.put(s.getId(), map);
    }

    public void setWeights(Species s, List<Field> weights) {
        Map<EnvelopeFields, Field> map = this.envelopeWeights.get(s.getId());
        if (map == null) {
            map = new HashMap<EnvelopeFields, Field>();
        }
        for (Field f : weights) {
            map.put(EnvelopeFields.valueOf(f.getName()), f);
        }
        this.envelopeWeights.put(s.getId(), map);
    }

    public Boolean getIsGis() {
        return this.isGis;
    }

    public void setIsGis(Boolean isGis) {
        this.isGis = isGis;
    }

    public String getWmsContextId() {
        return this.wmsContextId;
    }

    public void setWmsContextId(String wmsContextId) {
        this.wmsContextId = wmsContextId;
    }

    public String getCompressedCoverage() {
        return AquaMapsObject.generateMD5(this.selectedSpecies, "");
    }
}

