package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONArray;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube_system.namespaces.application.aquamaps.types.FieldArray;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

@XStreamAlias("Field")
public class Field extends DataModel implements Comparable<Field>{

	public static final String VOID="VOID";
	
	
	
	@XStreamAsAttribute
	private FieldType type=FieldType.STRING;
	@XStreamAsAttribute
	private String name;
	@XStreamAsAttribute
	private String value;

	public FieldType getType() {
		return type;
	}

	public Field() {
		type=FieldType.STRING;
		name="DefaultFieldName";
		value="DefaultValue";
	}

	public Field(String name,String value) {
		this();
		this.name=name;
		this.value=value;
	}
	public Field(String name,String value,FieldType type){
		this(name,value);
		this.setType(type);
	}


	public void setType(FieldType type) {
		this.type = type;		
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}

	public static List<Field> load(FieldArray toLoad){
		List<Field> toReturn=new ArrayList<Field>();
		if((toLoad!=null)&&(toLoad.getFields()!=null))
			for(org.gcube_system.namespaces.application.aquamaps.types.Field f:toLoad.getFields())toReturn.add(new Field(f));
		return toReturn;
	}

	public static org.gcube_system.namespaces.application.aquamaps.types.FieldArray toStubsVersion(Collection<Field> collection){
		List<org.gcube_system.namespaces.application.aquamaps.types.Field> list=new ArrayList<org.gcube_system.namespaces.application.aquamaps.types.Field>();
		if(collection!=null)
			for(Field obj:collection)
				list.add(obj.toStubsVersion());
		return new org.gcube_system.namespaces.application.aquamaps.types.FieldArray(list.toArray(new org.gcube_system.namespaces.application.aquamaps.types.Field[list.size()]));
	}


	public Field(org.gcube_system.namespaces.application.aquamaps.types.Field toLoad){
		super();
		this.setName(toLoad.getName());
		this.setType(FieldType.valueOf(toLoad.getType()));
		this.setValue(toLoad.getValue());
	}
	public org.gcube_system.namespaces.application.aquamaps.types.Field toStubsVersion(){
		org.gcube_system.namespaces.application.aquamaps.types.Field toReturn=new org.gcube_system.namespaces.application.aquamaps.types.Field();
		toReturn.setName(this.getName());
		toReturn.setType(this.getType().toString());
		toReturn.setValue(this.getValue());
		return toReturn;		
	}


	public String getOperator(){
		if(name.contains("min")) return ">=";
		else if(name.contains("max")) return "<=";
		else return "=";
	}



	
	public static List<Field> loadRow(ResultSet rs)throws Exception{
		ArrayList<Field> toReturn=new ArrayList<Field>();
		ResultSetMetaData rsMeta=rs.getMetaData();
		int colCount=rsMeta.getColumnCount();
		for(int i=1;i<=colCount;i++)
			toReturn.add(new Field(rsMeta.getColumnName(i),rs.getString(i),getType(rsMeta.getColumnType(i))));
		return toReturn;
	}
	
	public static FieldType getType(int SQLType){
		if(SQLType==Types.TIME||SQLType==Types.TIMESTAMP)return FieldType.TIMESTAMP;
		if(SQLType==Types.BIGINT||SQLType==Types.TINYINT||SQLType==Types.SMALLINT||
				SQLType==Types.INTEGER||SQLType==Types.BIT) return FieldType.INTEGER;
		if(SQLType==Types.FLOAT||SQLType==Types.DOUBLE||SQLType==Types.REAL||SQLType==Types.DECIMAL||SQLType==Types.NUMERIC) return FieldType.DOUBLE;
		if(SQLType==Types.BOOLEAN) return FieldType.BOOLEAN;
		return FieldType.STRING;
	}
	
	
	public static List<List<Field>> loadResultSet(ResultSet rs)throws SQLException{
		List<List<Field>> toReturn=new ArrayList<List<Field>>();
		ResultSetMetaData rsMeta=rs.getMetaData();
		int colCount=rsMeta.getColumnCount();
		while(rs.next()){
			List<Field> row=new ArrayList<Field>();
			for(int i=1;i<=colCount;i++)
				row.add(new Field(rsMeta.getColumnName(i),rs.getString(i),getType(rsMeta.getColumnType(i))));
			toReturn.add(row);
		}
		return toReturn;
	}
	
	
	//**************** VALUE PARSING
	
	public Double getValueAsDouble(){
		if(isNull()) return null;
			return Double.parseDouble(getValue());			
	}
	
	public Integer getValueAsInteger(){
		if(isNull()) return null;
			return Integer.parseInt(getValue());
	}
	public Long getValueAsLong(){
		if(isNull()) return null;
			return Long.parseLong(getValue());
	}
	public Boolean getValueAsBoolean(){
		if(isNull()) return null;
		try{
			Integer i=getValueAsInteger();			
			return Boolean.valueOf(i.equals(Integer.valueOf(1)));
		}catch(Exception e){
			return Boolean.parseBoolean(getValue());						
		}
	}

	
	//************** 
	
	
	public boolean isNull(){
		return getValue()==null||getValue().equals(VOID)||getValue().equals("")||getValue().equals(" ")||getValue().equalsIgnoreCase("null");
	}
	
	public boolean validate(){
		if(isNull()) return true;
		try{
		switch(getType()){
			case BOOLEAN : getValueAsBoolean();
			break;
			case DOUBLE : getValueAsDouble();
			break;
			case INTEGER : getValueAsInteger();
			break;
			case LONG : getValueAsLong();
			break;
		}
		return true;
		}catch(Throwable t){
			return false;
		}
	}
	
	//************** USE DEFAULT
	public Double getValueAsDouble(String defaultValue){
		try{
			return Double.parseDouble(getValue());			
		}catch(Exception e){return Double.parseDouble(defaultValue);}
	}
	
	public Integer getValueAsInteger(String defaultValue){
		try{
			return Integer.parseInt(getValue());
		}catch(Exception e) {return Integer.parseInt(defaultValue);}
	}
	public Long getValueAsLong(String defaultValue){
		try{
			return Long.parseLong(getValue());
		}catch(Exception e) {return Long.parseLong(defaultValue);}
	}
	public Boolean getValueAsBoolean(String defaultValue){
		try{
		 return Boolean.parseBoolean(getValue());
		}catch(Exception e){
			Integer i=getValueAsInteger();
			if(i!=null)
			return  Boolean.valueOf(i==1);
			else return Boolean.parseBoolean(defaultValue);
		}
	}
	
	public JSONObject toJSONObject() throws JSONException{
		JSONObject toReturn=new JSONObject();
		toReturn.put("name", name);
		toReturn.put("value", value);
		toReturn.put("type", type);
		return toReturn;
	}
	
	public Field(JSONObject obj)throws JSONException{
		this.setName(obj.getString("name"));
		this.setType(FieldType.valueOf(obj.getString("type")));
		this.setValue(obj.getString("value"));
	}
	
	public static ArrayList<Field> fromJSONArray(JSONArray array)throws JSONException{
		ArrayList<Field> toReturn=new ArrayList<Field>();
		for(int i=0;i<array.length();i++)
			toReturn.add(new Field(array.getJSONObject(i)));
		return toReturn;
	}
	public static JSONArray toJSONArray(List<Field> list) throws JSONException{
		JSONArray array=new JSONArray();
		for(Field f:list)array.put(f.toJSONObject());
		return array;
	}

	@Override
	public int compareTo(Field arg0) {
		return this.getName().compareTo(arg0.getName());
	}

	@Override
	public String toString() {
		return "Field [type=" + type + ", name=" + name + ", value=" + value
				+ "]";
	}
	
	
}
