package org.gcube.application.aquamaps.aquamapsservice.client.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.aquamaps.aquamapsservice.client.Constants;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DefaultDataManagement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.DataManagementPortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.service.DataManagementServiceAddressingLocator;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;

public class DataManagementPlugin extends AbstractPlugin<DataManagementPortType,DataManagement> {

	public DataManagementPlugin() {
		super(Constants.NAMESPACE+"/DataManagement");
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public DataManagement newProxy(ProxyDelegate<DataManagementPortType> delegate) {
		return new DefaultDataManagement(delegate);
	}

	@Override
	public DataManagementPortType resolve(EndpointReferenceType address,
			ProxyConfig<?, ?> config) throws Exception {
		return new DataManagementServiceAddressingLocator().getDataManagementPortTypePort(address);
	}
	
}
