/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.client.proxies;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.DataManagementPortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportCSVSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportOperation;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportTableRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportTableStatusType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GenerateMapsRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetGenerationLiveReportResponseType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ImportResourceRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.RemoveHSPECGroupGenerationRequestResponseType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.SetUserCustomQueryRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ViewCustomQueryRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ViewTableFormat;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ViewTableRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Analysis;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.CustomQueryDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.EnvironmentalExecutionReportItem;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.SourceGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SystemTable;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.utils.RSWrapper;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.core.types.VOID;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataManagement
implements DataManagement {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDataManagement.class);
    private static final long POLL_WAIT_TIME = 1500L;
    private static final int MAX_POLL_MULTIPLIER = 10;
    private final ProxyDelegate<DataManagementPortType> delegate;

    public DefaultDataManagement(ProxyDelegate<DataManagementPortType> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String analyzeTables(final Analysis request) throws RemoteException, Exception {
        Call<DataManagementPortType, String> call = new Call<DataManagementPortType, String>(){

            public String call(DataManagementPortType endpoint) throws Exception {
                return endpoint.analyzeTables(request.toStubsVersion());
            }
        };
        return (String)this.delegate.make((Call)call);
    }

    @Override
    public String submitRequest(final SourceGenerationRequest request) throws RemoteException, Exception {
        Call<DataManagementPortType, String> call = new Call<DataManagementPortType, String>(){

            public String call(DataManagementPortType endpoint) throws Exception {
                return endpoint.generateHSPECGroup(request.toStubsVersion());
            }
        };
        return (String)this.delegate.make((Call)call);
    }

    @Override
    public EnvironmentalExecutionReportItem getReport(final List<String> ids) throws RemoteException, Exception {
        Call<DataManagementPortType, EnvironmentalExecutionReportItem> call = new Call<DataManagementPortType, EnvironmentalExecutionReportItem>(){

            public EnvironmentalExecutionReportItem call(DataManagementPortType endpoint) throws Exception {
                GetGenerationLiveReportResponseType report = endpoint.getGenerationLiveReportGroup(new StringArray(ids.toArray(new String[ids.size()])));
                return new EnvironmentalExecutionReportItem(report.getPercent(), report.getResourceLoad(), report.getResourceMap(), report.getElaboratedSpecies());
            }
        };
        return (EnvironmentalExecutionReportItem)this.delegate.make((Call)call);
    }

    @Override
    public Integer generateMaps(String author, boolean enableGIS, Integer hspecId, List<Field> speciesFilter, boolean forceRegeneration) throws RemoteException, Exception {
        final GenerateMapsRequestType request = new GenerateMapsRequestType();
        request.setAuthor(author);
        request.setGenerateLayers(enableGIS);
        request.setHSPECId(hspecId.intValue());
        request.setSpeciesFilter(Field.toStubsVersion(speciesFilter));
        request.setForceRegeneration(forceRegeneration);
        Call<DataManagementPortType, Integer> call = new Call<DataManagementPortType, Integer>(){

            public Integer call(DataManagementPortType endpoint) throws Exception {
                return endpoint.generateMaps(request);
            }
        };
        return (Integer)this.delegate.make((Call)call);
    }

    @Override
    public String removeRequest(String id, boolean deleteData, boolean deleteJobs) throws RemoteException, Exception {
        final RemoveHSPECGroupGenerationRequestResponseType request = new RemoveHSPECGroupGenerationRequestResponseType();
        request.setRequestId(id);
        request.setRemoveTables(deleteData);
        request.setRemoveJobs(deleteJobs);
        Call<DataManagementPortType, String> call = new Call<DataManagementPortType, String>(){

            public String call(DataManagementPortType endpoint) throws Exception {
                endpoint.removeHSPECGroup(request);
                return "Done";
            }
        };
        return (String)this.delegate.make((Call)call);
    }

    @Override
    public List<Field> getDefaultSources() throws RemoteException, Exception {
        Call<DataManagementPortType, List<Field>> call = new Call<DataManagementPortType, List<Field>>(){

            public List<Field> call(DataManagementPortType pt) throws Exception {
                return Field.load(pt.getDefaultSources(new VOID()));
            }
        };
        return (List)this.delegate.make((Call)call);
    }

    @Override
    public Resource updateResource(final Resource toUpdate) throws RemoteException, Exception {
        Call<DataManagementPortType, Resource> call = new Call<DataManagementPortType, Resource>(){

            public Resource call(DataManagementPortType pt) throws Exception {
                return new Resource(pt.editResource(toUpdate.toStubsVersion()));
            }
        };
        return (Resource)this.delegate.make((Call)call);
    }

    @Override
    public void deleteResource(final int resourceId) throws RemoteException, Exception {
        Call<DataManagementPortType, Object> call = new Call<DataManagementPortType, Object>(){

            public Object call(DataManagementPortType endpoint) throws Exception {
                endpoint.removeResource(resourceId);
                return null;
            }
        };
        this.delegate.make((Call)call);
    }

    @Override
    public CustomQueryDescriptor setCustomQuery(String userId, String queryString) throws RemoteException, Exception {
        final SetUserCustomQueryRequestType request = new SetUserCustomQueryRequestType(queryString, userId);
        Call<DataManagementPortType, CustomQueryDescriptor> call = new Call<DataManagementPortType, CustomQueryDescriptor>(){

            public CustomQueryDescriptor call(DataManagementPortType endpoint) throws Exception {
                String id = endpoint.setCustomQuery(request);
                CustomQueryDescriptor desc = null;
                desc = new CustomQueryDescriptor(endpoint.getCustomQueryDescriptor(id));
                logger.debug("Sent request, response is " + desc);
                int multiplier = 1;
                while (!desc.getStatus().equals((Object)ExportStatus.COMPLETED) && !desc.getStatus().equals((Object)ExportStatus.ERROR)) {
                    long waitTime = 1500L * (long)multiplier;
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (multiplier < 10) {
                        ++multiplier;
                    }
                    desc = new CustomQueryDescriptor(endpoint.getCustomQueryDescriptor(id));
                    logger.debug("Sent request, response is " + desc);
                }
                logger.debug("Finished polling, result : " + desc);
                return desc;
            }
        };
        return (CustomQueryDescriptor)this.delegate.make((Call)call);
    }

    @Override
    public String viewCustomQuery(String userId, PagedRequestSettings settings) throws RemoteException, Exception {
        final ViewCustomQueryRequestType request = new ViewCustomQueryRequestType(settings, userId);
        Call<DataManagementPortType, String> call = new Call<DataManagementPortType, String>(){

            public String call(DataManagementPortType endpoint) throws Exception {
                return endpoint.viewCustomQuery(request);
            }
        };
        return (String)this.delegate.make((Call)call);
    }

    @Override
    public Integer asyncImportResource(File toImport, String userId, ResourceType type, String encoding, boolean[] fieldsMask, boolean hasHeader, char delimiter) throws RemoteException, Exception {
        RSWrapper wrapper = new RSWrapper();
        wrapper.add(toImport);
        String locator = wrapper.getLocator().toString();
        ExportCSVSettings settings = new ExportCSVSettings(String.valueOf(delimiter), encoding, fieldsMask, hasHeader);
        final ImportResourceRequestType request = new ImportResourceRequestType(settings, "" + (Object)((Object)type), locator, userId);
        Call<DataManagementPortType, Integer> call = new Call<DataManagementPortType, Integer>(){

            public Integer call(DataManagementPortType endpoint) throws Exception {
                return endpoint.importResource(request);
            }
        };
        return (Integer)this.delegate.make((Call)call);
    }

    @Override
    public Resource syncImportResource(File toImport, String userId, ResourceType type, String encoding, boolean[] fieldsMask, boolean hasHeader, char delimiter) throws RemoteException, Exception {
        Integer resId = this.asyncImportResource(toImport, userId, type, encoding, fieldsMask, hasHeader, delimiter);
        logger.debug("Sent import request, resource Id is : " + resId);
        int multiplier = 1;
        Resource res = this.loadResource(resId);
        while (!res.getStatus().equals((Object)ResourceStatus.Completed) && !res.getStatus().equals((Object)ResourceStatus.Error)) {
            long waitTime = 1500L * (long)multiplier;
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (multiplier < 10) {
                ++multiplier;
            }
            res = this.loadResource(resId);
            logger.debug("Importing resource " + res);
        }
        return res;
    }

    @Override
    public File exportTableAsCSV(String table, String basketId, String user, String toSaveName, ExportOperation operationType) throws RemoteException, Exception {
        final ExportTableRequestType request = new ExportTableRequestType(basketId, new ExportCSVSettings(",", Charset.defaultCharset().toString(), new boolean[1], true), operationType, table, toSaveName, user);
        Call<DataManagementPortType, String> idCall = new Call<DataManagementPortType, String>(){

            public String call(DataManagementPortType endpoint) throws Exception {
                return endpoint.exportTableAsCSV(request);
            }
        };
        final String exportId = (String)this.delegate.make((Call)idCall);
        Call<DataManagementPortType, ExportTableStatusType> statusCall = new Call<DataManagementPortType, ExportTableStatusType>(){

            public ExportTableStatusType call(DataManagementPortType endpoint) throws Exception {
                return endpoint.getExportStatus(exportId);
            }
        };
        ExportTableStatusType desc = null;
        int multiplier = 1;
        desc = (ExportTableStatusType)this.delegate.make((Call)statusCall);
        while (!desc.getStatus().equals((Object)ExportStatus.COMPLETED) && !desc.getStatus().equals((Object)ExportStatus.ERROR)) {
            try {
                Thread.sleep(1500L * (long)multiplier);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (multiplier < 10) {
                ++multiplier;
            }
            desc = (ExportTableStatusType)this.delegate.make((Call)statusCall);
        }
        if (desc.getStatus().equals((Object)ExportStatus.ERROR)) {
            throw new Exception(desc.getErrors());
        }
        return RSWrapper.getStreamFromLocator(new URI(desc.getRsLocator()));
    }

    @Override
    public File loadAnalysisResults(final String id) throws RemoteException, Exception {
        Call<DataManagementPortType, File> call = new Call<DataManagementPortType, File>(){

            public File call(DataManagementPortType endpoint) throws Exception {
                String locator = endpoint.loadAnalysis(id);
                return RSWrapper.getStreamFromLocator(new URI(locator));
            }
        };
        return (File)this.delegate.make((Call)call);
    }

    @Override
    public String resubmitGeneration(final String id) throws RemoteException, Exception {
        Call<DataManagementPortType, String> call = new Call<DataManagementPortType, String>(){

            public String call(DataManagementPortType endpoint) throws Exception {
                return endpoint.resubmitGeneration(id);
            }
        };
        return (String)this.delegate.make((Call)call);
    }

    @Override
    public void deleteAnalysis(final String id) throws RemoteException, Exception {
        Call<DataManagementPortType, Object> call = new Call<DataManagementPortType, Object>(){

            public Object call(DataManagementPortType endpoint) throws Exception {
                endpoint.deleteAnalysis(id);
                return null;
            }
        };
        this.delegate.make((Call)call);
    }

    @Override
    public String getJSONView(final PagedRequestSettings settings, final String tableName, final List<Field> filters) throws RemoteException, Exception {
        Call<DataManagementPortType, String> call = new Call<DataManagementPortType, String>(){

            public String call(DataManagementPortType endpoint) throws Exception {
                ViewTableRequestType request = new ViewTableRequestType();
                request.setFilter(Field.toStubsVersion(filters));
                request.setFormat(ViewTableFormat.JSON);
                request.setSettings(settings);
                request.setTablename(tableName);
                return endpoint.viewTable(request);
            }
        };
        return (String)this.delegate.make((Call)call);
    }

    @Override
    public String getSystemTableName(SystemTable tableType) throws RemoteException, Exception {
        switch (tableType) {
            case ANALYSIS_REQUESTS: {
                return "analysis_table";
            }
            case DATASOURCES_METADATA: {
                return "meta_sources";
            }
            case OCCURRENCE_CELLS: {
                return "occurrencecells";
            }
            case SPECIES_SUMMARY: {
                return "speciesoccursum";
            }
            case SUBMITTED_MAP_REQUESTS: {
                return "submitted";
            }
            case DATASOURCE_GENERATION_REQUESTS: {
                return "source_generation_requests";
            }
        }
        throw new Exception("Invalid table type " + (Object)((Object)tableType));
    }

    @Override
    public Resource loadResource(final int resId) throws RemoteException, Exception {
        Call<DataManagementPortType, Resource> call = new Call<DataManagementPortType, Resource>(){

            public Resource call(DataManagementPortType endpoint) throws Exception {
                Resource request = new Resource(ResourceType.HCAF, resId);
                return new Resource(endpoint.getResourceInfo(request.toStubsVersion()));
            }
        };
        return (Resource)this.delegate.make((Call)call);
    }
}

