/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.io.FileUtils;
import org.gcube.common.core.utils.logging.GCUBELog;

public class ServiceUtils {
    private static DateFormat dateFormatter = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS_z");
    private static DateFormat shortDateFormatter = new SimpleDateFormat("yyyy_MM_dd");
    private static final GCUBELog logger = new GCUBELog(ServiceUtils.class);

    public static String fileToString(String path) throws IOException {
        BufferedReader filebuf = null;
        String nextStr = null;
        StringBuilder ret = new StringBuilder();
        filebuf = new BufferedReader(new FileReader(path));
        nextStr = filebuf.readLine();
        while (nextStr != null) {
            ret.append(nextStr);
            nextStr = filebuf.readLine();
        }
        filebuf.close();
        return ret.toString();
    }

    public static String URLtoString(String path) throws IOException {
        String inputLine;
        URL yahoo = new URL(path);
        BufferedReader in = new BufferedReader(new InputStreamReader(yahoo.openStream()));
        StringBuilder toReturn = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            toReturn.append(inputLine);
        }
        in.close();
        return toReturn.toString();
    }

    public static void deleteFile(String path) throws IOException {
        File f = new File(path);
        if (f.exists()) {
            if (f.isDirectory()) {
                logger.info((Object)("Deleting directory " + path));
                FileUtils.cleanDirectory((File)f);
                FileUtils.deleteDirectory((File)f);
            } else {
                logger.info((Object)("Deleting file " + path));
                File dir = f.getParentFile();
                FileUtils.forceDelete((File)f);
                if (dir.list().length == 0) {
                    logger.info((Object)("Deleting empty parent " + dir.getAbsolutePath()));
                    FileUtils.deleteDirectory((File)dir);
                }
            }
        } else {
            logger.info((Object)("Path not found " + path));
        }
    }

    public static String generateId(String prefix, String suffix) {
        return String.valueOf(prefix) + ServiceUtils.getTimeStamp().replaceAll("-", "_") + suffix;
    }

    public static String getTimeStamp() {
        return ServiceUtils.formatTimeStamp(System.currentTimeMillis());
    }

    public static String getDate() {
        return shortDateFormatter.format(System.currentTimeMillis());
    }

    public static String formatTimeStamp(long time) {
        return dateFormatter.format(time);
    }
}

