/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalysisResponseDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalysisWorker;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.Analyzer;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Analysis;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AnalysisType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;

public class AnalysisRequest {
    private AnalysisType toPerformAnalysis = null;
    private String[] hcafTables = null;
    private String[] hcafLabels = null;
    private String[] hspecTables = null;
    private String[] hspecLabels = null;
    private String[] hspenTables = null;
    private String[] hspenLabels = null;
    private String[] occurrenceTables = null;
    private String[] occurrenceLabels = null;
    private float hspecThreshold = 0.8f;
    private AnalysisWorker toNotify;

    public static final List<AnalysisRequest> getRequests(Analysis toPerform, AnalysisWorker toNotify) throws Exception {
        ArrayList<AnalysisRequest> toReturn = new ArrayList<AnalysisRequest>();
        ArrayList<Resource> sources = new ArrayList<Resource>();
        for (Integer id : toPerform.getSources()) {
            sources.add(SourceManager.getById(id));
        }
        HashMap sourceTables = new HashMap();
        HashMap sourceLabels = new HashMap();
        for (Resource r : sources) {
            if (!sourceTables.containsKey(r.getType())) {
                sourceTables.put(r.getType(), new ArrayList());
                sourceLabels.put(r.getType(), new ArrayList());
            }
            ((ArrayList)sourceTables.get(r.getType())).add(r.getTableName());
            ((ArrayList)sourceLabels.get(r.getType())).add(r.getTitle());
        }
        String[] hcafTables = null;
        String[] hcafLabels = null;
        String[] hspecTables = null;
        String[] hspecLabels = null;
        String[] hspenTables = null;
        String[] hspenLabels = null;
        String[] occurrenceTables = null;
        String[] occurrenceLabels = null;
        ResourceType[] resourceTypeArray = ResourceType.values();
        int n = resourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceType type = resourceTypeArray[n2];
            if (sourceTables.containsKey(type) != sourceLabels.containsKey(type)) {
                throw new Exception("Incoherent labels/tables for " + type + ", TABLES : " + sourceTables.keySet() + ", LABELS : " + sourceLabels.keySet());
            }
            if (sourceTables.containsKey(type)) {
                if (((ArrayList)sourceTables.get(type)).size() != ((ArrayList)sourceLabels.get(type)).size()) {
                    throw new Exception("Incoherent labels/tables for " + type + ", TABLES : " + sourceTables.get(type) + ", LABELS : " + sourceLabels.get(type));
                }
                if (((ArrayList)sourceTables.get(type)).size() < 2) {
                    throw new Exception("Not enough sources for " + type);
                }
                switch (type) {
                    case HCAF: {
                        hcafTables = AnalysisRequest.listToString((List)sourceTables.get(type));
                        hcafLabels = AnalysisRequest.listToString((List)sourceLabels.get(type));
                        break;
                    }
                    case HSPEN: {
                        hspenTables = AnalysisRequest.listToString((List)sourceTables.get(type));
                        hspenLabels = AnalysisRequest.listToString((List)sourceLabels.get(type));
                        break;
                    }
                    case HSPEC: {
                        hspecTables = AnalysisRequest.listToString((List)sourceTables.get(type));
                        hspecLabels = AnalysisRequest.listToString((List)sourceLabels.get(type));
                        break;
                    }
                    case OCCURRENCECELLS: {
                        occurrenceTables = AnalysisRequest.listToString((List)sourceTables.get(type));
                        occurrenceLabels = AnalysisRequest.listToString((List)sourceLabels.get(type));
                    }
                }
            }
            ++n2;
        }
        for (ResourceType type : toPerform.getType()) {
            toReturn.add(new AnalysisRequest((AnalysisType)type, hcafTables, hcafLabels, hspecTables, hspecLabels, hspenTables, hspenLabels, occurrenceTables, occurrenceLabels, 0.8f, toNotify));
        }
        return toReturn;
    }

    private static final String[] listToString(List<String> toCopy) {
        String[] toReturn = new String[toCopy.size()];
        int i = 0;
        while (i < toCopy.size()) {
            toReturn[i] = toCopy.get(i);
            ++i;
        }
        return toReturn;
    }

    private AnalysisRequest(AnalysisType toPerformAnalysis, String[] hcafTables, String[] hcafLabels, String[] hspecTables, String[] hspecLabels, String[] hspenTables, String[] hspenLabels, String[] occurrenceTables, String[] occurrenceLabels, float hspecThreshold, AnalysisWorker toNotify) {
        this.toPerformAnalysis = toPerformAnalysis;
        this.hcafTables = hcafTables;
        this.hcafLabels = hcafLabels;
        this.hspecTables = hspecTables;
        this.hspecLabels = hspecLabels;
        this.hspenTables = hspenTables;
        this.hspenLabels = hspenLabels;
        this.occurrenceTables = occurrenceTables;
        this.occurrenceLabels = occurrenceLabels;
        this.hspecThreshold = hspecThreshold;
        this.toNotify = toNotify;
    }

    public String[] getLabels(ResourceType type) {
        switch (type) {
            case HCAF: {
                return this.hcafLabels;
            }
            case HSPEC: {
                return this.hspecLabels;
            }
            case HSPEN: {
                return this.hspenLabels;
            }
        }
        return this.occurrenceLabels;
    }

    public String[] getTables(ResourceType type) {
        switch (type) {
            case HCAF: {
                return this.hcafTables;
            }
            case HSPEC: {
                return this.hspecTables;
            }
            case HSPEN: {
                return this.hspenTables;
            }
        }
        return this.occurrenceTables;
    }

    public AnalysisType getToPerformAnalysis() {
        return this.toPerformAnalysis;
    }

    public float getHspecThreshold() {
        return this.hspecThreshold;
    }

    public void notify(AnalysisResponseDescriptor descriptor, Analyzer analyzer) {
        this.toNotify.notifyGenerated(descriptor, analyzer);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnalysisRequest [toPerformAnalysis=");
        builder.append(this.toPerformAnalysis);
        builder.append(", hcafTables=");
        builder.append(Arrays.toString(this.hcafTables));
        builder.append(", hcafLabels=");
        builder.append(Arrays.toString(this.hcafLabels));
        builder.append(", hspecTables=");
        builder.append(Arrays.toString(this.hspecTables));
        builder.append(", hspecLabels=");
        builder.append(Arrays.toString(this.hspecLabels));
        builder.append(", hspenTables=");
        builder.append(Arrays.toString(this.hspenTables));
        builder.append(", hspenLabels=");
        builder.append(Arrays.toString(this.hspenLabels));
        builder.append(", occurrenceTables=");
        builder.append(Arrays.toString(this.occurrenceTables));
        builder.append(", occurrenceLabels=");
        builder.append(Arrays.toString(this.occurrenceLabels));
        builder.append(", hspecThreshold=");
        builder.append(this.hspecThreshold);
        builder.append(", toNotify=");
        builder.append(this.toNotify);
        builder.append("]");
        return builder.toString();
    }
}

