/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.gcube.common.core.utils.logging.GCUBELog;

public class PropertiesReader {
    private static final GCUBELog logger = new GCUBELog(PropertiesReader.class);
    private long lastAccessed = 0L;
    private Properties props = new Properties();
    private static long refreshTime = 180000L;
    private String path;
    private static PropertiesReader instance;

    private PropertiesReader(String path) throws Exception {
        this.path = path;
    }

    public static PropertiesReader get(String path) throws Exception {
        if (instance == null) {
            instance = new PropertiesReader(path);
        }
        return instance;
    }

    public String getParam(String paramName) throws Exception {
        long secondsFromLastRead = (System.currentTimeMillis() - this.lastAccessed) / 1000L;
        if (secondsFromLastRead >= refreshTime) {
            this.load();
            this.lastAccessed = System.currentTimeMillis();
        }
        return this.props.getProperty(paramName).trim();
    }

    private void load() throws Exception {
        InputStream is = null;
        try {
            String propertiesFilePath = this.path;
            logger.debug((Object)("******************* LOADING propertiesFilePath " + propertiesFilePath));
            is = new FileInputStream(propertiesFilePath);
            this.props.load(is);
            is.close();
            logger.debug((Object)("loaded properties file :" + this.props.toString()));
        }
        finally {
            is.close();
        }
    }
}

