/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.apache.tools.ant.util.FileUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads.StatefullCSVLineProcessor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.common.core.utils.logging.GCUBELog;

public class SourceImporter
extends Thread {
    private static final GCUBELog logger = new GCUBELog(SourceImporter.class);
    private String csv;
    private Resource importing;
    private Integer metaId;
    private char delimiter;
    private boolean[] fieldSelection;
    private boolean hasHeaders;

    public SourceImporter(String csv, Resource i, Integer metaId, char delimiter, boolean[] fieldSelection, boolean hasHeaders, String encoding) {
        this.csv = csv;
        this.importing = i;
        this.metaId = metaId;
        this.delimiter = delimiter;
        this.fieldSelection = fieldSelection;
        this.hasHeaders = hasHeaders;
    }

    @Override
    public void run() {
        DBSession session = null;
        StatefullCSVLineProcessor lineProcessor = null;
        try {
            try {
                logger.debug((Object)("Started importing operation from " + this.csv + " TO " + this.importing.getTableName()));
                long toInsertCount = CSVUtils.countCSVRows((String)this.csv, (char)this.delimiter, (boolean)this.hasHeaders);
                if (toInsertCount == 0L) {
                    throw new Exception("No rows to insert from csv file " + this.csv);
                }
                logger.info((Object)("Found " + toInsertCount + " rows in csv file"));
                Resource defaultResource = SourceManager.getById(SourceManager.getDefaultId(this.importing.getType()));
                session = DBSession.getInternalDBSession();
                logger.debug((Object)("Going to evaluate default table " + defaultResource.getTableName() + " fields"));
                ResultSet templateRs = session.executeQuery("SELECT * FROM " + defaultResource.getTableName() + " LIMIT 1 OFFSET 0");
                templateRs.next();
                List model = Field.loadRow((ResultSet)templateRs);
                session.close();
                CSVReaderProcessor processor = new CSVReaderProcessor();
                processor.setDelimiter(this.delimiter);
                processor.setHasHeader(this.hasHeaders);
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.csv), Charset.defaultCharset());
                lineProcessor = new StatefullCSVLineProcessor(model, this.importing, toInsertCount, this.fieldSelection);
                logger.debug((Object)"Starting file processing");
                processor.processStream((Reader)reader, (CSVLineProcessor)lineProcessor);
                logger.debug((Object)"Complete processing");
                logger.debug((Object)("Completed import of source ID " + this.importing.getSearchId()));
            }
            catch (Exception e) {
                logger.error((Object)"Unexpected Exception ", (Throwable)e);
                this.importing.setStatus(ResourceStatus.Error);
                try {
                    SourceManager.update(this.importing);
                }
                catch (Exception e1) {
                    logger.error((Object)("Unable to update resource " + this.metaId), (Throwable)e1);
                }
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception e2) {
                        logger.fatal((Object)"Unable to close session ", (Throwable)e2);
                    }
                }
                if (lineProcessor != null) {
                    lineProcessor.close();
                }
                FileUtils.delete((File)new File(this.csv));
            }
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    logger.fatal((Object)"Unable to close session ", (Throwable)e);
                }
            }
            if (lineProcessor != null) {
                lineProcessor.close();
            }
            FileUtils.delete((File)new File(this.csv));
        }
    }
}

