/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.MySQLDBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.PoolManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.PostGresSQLDBSession;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.HSPECFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.enabling.model.DBDescriptor;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;

public abstract class DBSession {
    protected static GCUBELog logger = new GCUBELog(DBSession.class);
    protected static String CSV_DELIMITER = ",";
    protected Connection connection;

    public Connection getConnection() {
        return this.connection;
    }

    public static DBDescriptor getInternalCredentials() throws Exception {
        return ServiceContext.getContext().getConfiguration().getInternalDB(ServiceContext.getContext().getConfigurationScope());
    }

    public static DBDescriptor getPostGisCredentials() throws Exception {
        return ServiceContext.getContext().getConfiguration().getGeoServerDb(ServiceContext.getContext().getConfigurationScope());
    }

    public static DBSession getInternalDBSession() throws Exception {
        try {
            Connection conn = PoolManager.getInternalDBConnection();
            switch (DBSession.getInternalCredentials().getType()) {
                case mysql: {
                    return new MySQLDBSession(conn);
                }
            }
            return new PostGresSQLDBSession(conn);
        }
        catch (Exception e) {
            logger.fatal((Object)"ERROR ON OPENING CONNECTION ", (Throwable)e);
            logger.fatal((Object)("Connection parameters were : " + DBSession.getInternalCredentials()));
            throw e;
        }
    }

    public static DBSession getPostGisDBSession() throws Exception {
        return new PostGresSQLDBSession(PoolManager.getPostGisDBConnection());
    }

    protected DBSession(Connection conn) {
        this.connection = conn;
    }

    public void close() throws Exception {
        this.connection.close();
    }

    public void disableAutoCommit() throws Exception {
        this.connection.setAutoCommit(false);
    }

    public void commit() throws Exception {
        this.connection.commit();
    }

    @Deprecated
    protected DBSession() {
    }

    @Deprecated
    public ResultSet executeQuery(String query) throws Exception {
        Statement statement = this.connection.createStatement(1004, 1007);
        return statement.executeQuery(query);
    }

    public abstract void createTable(String var1, String[] var2) throws Exception;

    public void disableKeys(String tableName) throws Exception {
        Statement statement = this.connection.createStatement();
        statement.execute("alter table " + tableName + " DISABLE KEYS");
        statement.close();
    }

    public void enableKeys(String tableName) throws Exception {
        Statement statement = this.connection.createStatement();
        statement.execute("alter table " + tableName + " ENABLE KEYS");
        statement.close();
    }

    public abstract void createLikeTable(String var1, String var2) throws Exception;

    public void alterColumn(String tableName, ALTER_OPERATION op, String ... columnsAndConstraintDefinition) throws Exception {
        Statement statement = this.connection.createStatement();
        StringBuilder createQuery = new StringBuilder("ALTER TABLE " + tableName + " ");
        String[] stringArray = columnsAndConstraintDefinition;
        int n = columnsAndConstraintDefinition.length;
        int n2 = 0;
        while (n2 < n) {
            String singleColumnDef = stringArray[n2];
            createQuery.append(" " + op.toString() + " COLUMN " + singleColumnDef + ",");
            ++n2;
        }
        createQuery.deleteCharAt(createQuery.length() - 1);
        createQuery.append(";");
        logger.debug((Object)("the query is: " + createQuery.toString()));
        try {
            statement.executeUpdate(createQuery.toString());
        }
        catch (SQLException sqle) {
            logger.warn((Object)"error altering table");
        }
        statement.close();
    }

    public void createIndex(String tableName, String columnName) throws Exception {
        Statement statement = this.connection.createStatement();
        StringBuilder createQuery = new StringBuilder("CREATE INDEX IDX_" + tableName + "_" + columnName + " ON " + tableName + "(" + columnName + ");");
        logger.debug((Object)("the query is: " + createQuery.toString()));
        statement.executeUpdate(createQuery.toString());
        statement.close();
    }

    public void deleteColumn(String tableName, String columnName) throws Exception {
        Statement statement = this.connection.createStatement();
        String query = "ALTER TABLE " + tableName + " drop column " + columnName;
        logger.debug((Object)("the query is: " + query));
        statement.executeUpdate(query.toString());
        statement.close();
    }

    public void dropTable(String table) throws Exception {
        Statement statement = this.connection.createStatement();
        statement.executeUpdate("DROP TABLE IF EXISTS " + table + " ");
        statement.close();
    }

    public void dropView(String view) throws Exception {
        Statement statement = this.connection.createStatement();
        statement.executeUpdate("DROP VIEW IF EXISTS " + view + " ");
        statement.close();
    }

    public abstract PreparedStatement getFilterCellByAreaQuery(HSPECFields var1, String var2, String var3) throws Exception;

    protected PreparedStatement getPreparedStatementForCount(List<Field> filters, String tableName) throws SQLException {
        return this.connection.prepareStatement(DBSession.formSelectCountString(filters, tableName));
    }

    public PreparedStatement getPreparedStatementForQuery(List<Field> filters, String table, String orderColumn, OrderDirection orderDirection) throws SQLException {
        return this.connection.prepareStatement(DBSession.formSelectQueryStringFromFields(filters, table, orderColumn, orderDirection));
    }

    public PreparedStatement getPreparedStatementForDISTINCT(List<Field> filters, Field toSelect, String table, String orderColumn, OrderDirection orderDirection) throws SQLException {
        return this.connection.prepareStatement(DBSession.formSelectDistinctQueryStringFromFields(filters, toSelect, table, orderColumn, orderDirection));
    }

    public PreparedStatement getPreparedStatementForUpdate(List<Field> toSet, List<Field> keys, String tableName) throws SQLException {
        return this.connection.prepareStatement(DBSession.formUpdateQuery(toSet, keys, tableName), 1);
    }

    public PreparedStatement getPreparedStatementForInsertFromSelect(List<Field> fields, String destTable, String srcTable) throws Exception {
        String query = "INSERT INTO " + destTable + " ( " + DBSession.formSelectQueryStringFromFields(fields, srcTable, null, null) + " )";
        PreparedStatement ps = this.preparedStatement(query);
        return ps;
    }

    public PreparedStatement getPreparedStatementForInsert(List<Field> fields, String table) throws Exception {
        StringBuilder fieldsName = new StringBuilder("(");
        StringBuilder fieldsValues = new StringBuilder("(");
        for (Field f : fields) {
            fieldsValues.append("?,");
            fieldsName.append(String.valueOf(f.getName()) + ",");
        }
        logger.debug((Object)(" the values are " + fields.size()));
        fieldsValues.deleteCharAt(fieldsValues.length() - 1);
        fieldsValues.append(")");
        fieldsName.deleteCharAt(fieldsName.length() - 1);
        fieldsName.append(")");
        String query = "INSERT INTO " + table + " " + fieldsName + " VALUES " + fieldsValues;
        logger.debug((Object)("the prepared statement is :" + query));
        PreparedStatement ps = this.connection.prepareStatement(query, 1);
        return ps;
    }

    public abstract PreparedStatement getPreparedStatementForInsertOnDuplicate(List<Field> var1, String var2, Integer[] var3) throws Exception;

    public PreparedStatement getPreparedStatementForDelete(List<Field> fields, String table) throws Exception {
        PreparedStatement ps = this.preparedStatement(DBSession.formDeletetQueryStringFromFields(fields, table));
        return ps;
    }

    @Deprecated
    public PreparedStatement preparedStatement(String query) throws Exception {
        return this.connection.prepareStatement(query, 1004, 1007);
    }

    public abstract PreparedStatement fillParameters(List<Field> var1, int var2, PreparedStatement var3) throws SQLException;

    public abstract String exportTableToCSV(String var1, boolean var2, char var3) throws Exception;

    public abstract boolean checkExist(String var1, List<Field> var2) throws Exception;

    public abstract List<List<Field>> insertOperation(String var1, List<List<Field>> var2) throws Exception;

    public abstract int updateOperation(String var1, List<List<Field>> var2, List<List<Field>> var3) throws Exception;

    public abstract ResultSet executeFilteredQuery(List<Field> var1, String var2, String var3, OrderDirection var4) throws Exception;

    public abstract Long getCount(String var1, List<Field> var2) throws Exception;

    public abstract int deleteOperation(String var1, List<Field> var2) throws Exception;

    public long getTableCount(String tableName) throws Exception {
        Statement statement = this.connection.createStatement();
        ResultSet rs = statement.executeQuery("SELECT COUNT(*) FROM " + tableName);
        long value = 0L;
        if (rs.next()) {
            value = rs.getLong(1);
        }
        statement.close();
        return value;
    }

    public abstract ResultSet getDistinct(Field var1, List<Field> var2, String var3, String var4, OrderDirection var5) throws Exception;

    @Deprecated
    public void executeUpdate(String query) throws Exception {
        Statement statement = this.connection.createStatement();
        statement.executeUpdate(query);
        statement.close();
    }

    public boolean checkTableExist(String tableName) throws Exception {
        Statement stmt = this.connection.createStatement();
        try {
            try {
                stmt.execute("SELECT * FROM " + tableName + " LIMIT 1 OFFSET 0");
            }
            catch (SQLException e) {
                stmt.close();
                return false;
            }
        }
        finally {
            stmt.close();
        }
        return true;
    }

    protected List<List<Field>> getGeneratedKeys(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.getGeneratedKeys();
        ResultSetMetaData rsMeta = rs.getMetaData();
        ArrayList<List<Field>> toReturn = new ArrayList<List<Field>>();
        while (rs.next()) {
            ArrayList<Field> row = new ArrayList<Field>();
            int i = 1;
            while (i <= rsMeta.getColumnCount()) {
                row.add(new Field(rsMeta.getColumnName(i), rs.getString(i), FieldType.STRING));
                ++i;
            }
            toReturn.add(row);
        }
        return toReturn;
    }

    protected static String formSelectQueryStringFromFields(List<Field> filters, String table, String sortColumn, OrderDirection sortDirection) {
        String toReturn = "SELECT * FROM " + table + (filters != null && filters.size() > 0 ? " WHERE " + DBSession.getCondition(filters, "AND") : "") + (sortColumn != null && !sortColumn.equalsIgnoreCase("null") ? " ORDER BY " + sortColumn + " " + sortDirection : "");
        return toReturn;
    }

    protected static String formSelectDistinctQueryStringFromFields(List<Field> filters, Field toSelectField, String table, String sortColumn, OrderDirection sortDirection) {
        String toReturn = "SELECT DISTINCT(" + toSelectField.getName() + ") FROM " + table + (filters != null && filters.size() > 0 ? " WHERE " + DBSession.getCondition(filters, "AND") : "") + (sortColumn != null && !sortColumn.equalsIgnoreCase("null") ? " ORDER BY " + sortColumn + " " + sortDirection : "");
        return toReturn;
    }

    protected static String formSelectCountString(List<Field> filters, String tableName) {
        return "SELECT COUNT(*) FROM " + tableName + (filters != null && filters.size() > 0 ? " WHERE " + DBSession.getCondition(filters, "AND") : "");
    }

    protected static String formDeletetQueryStringFromFields(List<Field> filters, String table) {
        return "DELETE FROM " + table + (filters != null && filters.size() > 0 ? " WHERE " + DBSession.getCondition(filters, "AND") : "");
    }

    protected static String formUpdateQuery(List<Field> toSet, List<Field> keys, String tableName) {
        String toReturn = "UPDATE " + tableName + " SET " + DBSession.getCondition(toSet, ",") + (keys != null && keys.size() > 0 ? " WHERE " + DBSession.getCondition(keys, "AND") : "");
        return toReturn;
    }

    private static String getCondition(List<Field> filters, String operator) {
        StringBuilder query = new StringBuilder();
        if (filters != null && filters.size() > 0) {
            for (Field f : filters) {
                query.append(" " + f.getName() + " = ? " + operator);
            }
            query.delete(query.lastIndexOf(operator), query.lastIndexOf(operator) + operator.length());
        }
        return "" + query;
    }

    public static enum ALTER_OPERATION {
        MODIFY,
        ADD;

    }

    public static enum ENGINE {
        MyISAM,
        InnoDB;

    }
}

