/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.imageio.ImageIO;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.AnalysisTableManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalysisRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalysisResponseDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.Analyzer;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalyzerManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.ImageDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Analysis;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.utils.AppZip;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;

public class AnalysisWorker
extends Thread {
    private static final GCUBELog logger = new GCUBELog(AnalysisWorker.class);
    private Analysis toPerform;
    private AnalysisResponseDescriptor produced = new AnalysisResponseDescriptor(null);
    final Semaphore blocking = new Semaphore(0);

    public AnalysisWorker(Analysis analysis) {
        this.toPerform = analysis;
    }

    @Override
    public void run() {
        Analyzer analyzer = null;
        logger.trace((Object)("Starting execution for request ID " + this.toPerform.getId()));
        logger.trace((Object)("Anaylisis to Perform : " + this.toPerform.toXML()));
        try {
            AnalysisTableManager.setStartTime(this.toPerform.getId());
            AnalysisTableManager.setPhasePercent(0.0, this.toPerform.getId());
            List<AnalysisRequest> requests = AnalysisRequest.getRequests(this.toPerform, this);
            for (AnalysisRequest analysisRequest : requests) {
                analyzer = AnalyzerManager.getBatch();
                logger.debug((Object)("Got batch Id " + analyzer.getReportId()));
                analyzer.setConfiguration(String.valueOf(ServiceContext.getContext().getFile("generator", new boolean[]{false}).getAbsolutePath()) + File.separator, DBSession.getInternalCredentials());
                AnalysisTableManager.addReportId(analyzer.getReportId(), this.toPerform.getId());
                analyzer.produceImages(analysisRequest);
            }
            logger.debug((Object)("Going to wait for " + requests.size() + " analyzers"));
            this.blocking.acquire(requests.size());
            logger.debug((Object)"Woken up");
            for (Map.Entry entry : this.produced.getMessages().entrySet()) {
                logger.warn((Object)("Error message from execution, Analysis : " + entry.getKey() + ", message : " + (String)entry.getValue()));
            }
            String string = AnalysisWorker.archiveImages(this.produced, this.toPerform.getTitle()).getAbsolutePath();
            logger.trace((Object)("Generated archive file " + string));
            AnalysisTableManager.setArchivePath(this.toPerform.getId(), string);
            AnalysisTableManager.setStatus(SubmittedStatus.Completed, this.toPerform.getId());
        }
        catch (Exception e) {
            logger.error((Object)("Unexpected Exception while performing " + this.toPerform.toXML()), (Throwable)e);
            try {
                AnalysisTableManager.setStatus(SubmittedStatus.Error, this.toPerform.getId());
            }
            catch (Exception exception) {
                logger.fatal((Object)"Unable to update reference status for analysis", (Throwable)exception);
            }
        }
    }

    private static File archiveImages(AnalysisResponseDescriptor produced, String name) throws Exception {
        File directory = new File(ServiceContext.getContext().getFolderPath(ServiceContext.FOLDERS.ANALYSIS), ServiceUtils.generateId(name, ""));
        directory.mkdirs();
        for (Map.Entry<String, ArrayList<ImageDescriptor>> entry : produced.getCategorizedImages().entrySet()) {
            File subDir = new File(directory, entry.getKey());
            subDir.mkdirs();
            int i = 0;
            while (i < entry.getValue().size()) {
                Image image = entry.getValue().get(i).getImage();
                BufferedImage bi = ImageTools.toBufferedImage((Image)image);
                File outputfile = new File(subDir, String.valueOf(entry.getValue().get(i).getName()) + ".png");
                ImageIO.write((RenderedImage)bi, "png", outputfile);
                ++i;
            }
        }
        File toReturn = new File(ServiceContext.getContext().getFolderPath(ServiceContext.FOLDERS.ANALYSIS), ServiceUtils.generateId("Analysis", ".zip"));
        AppZip zip = new AppZip(directory.getAbsolutePath());
        logger.trace((Object)("Zipped " + zip.zipIt(toReturn.getAbsolutePath()) + " files to " + toReturn.getAbsolutePath()));
        ServiceUtils.deleteFile(directory.getAbsolutePath());
        return toReturn;
    }

    public void notifyGenerated(AnalysisResponseDescriptor result, Analyzer analyzer) {
        logger.debug((Object)("Releasing... analyzerId is " + analyzer.getReportId()));
        this.produced.append(result);
        this.blocking.release();
        if (analyzer != null) {
            try {
                AnalyzerManager.leaveBatch(analyzer);
                AnalysisTableManager.removeReportId(analyzer.getReportId(), this.toPerform.getId());
                AnalysisTableManager.addCompletedAnalysis(this.toPerform.getId(), result.getType());
            }
            catch (Exception e) {
                logger.fatal((Object)"Unable to leave analyzer", (Throwable)e);
            }
        }
    }
}

