/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.AquaMapsManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SpeciesStatus;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SubmittedManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.Generator;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMapsObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Job;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SpeciesOccursumFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;

public class JobManager
extends SubmittedManager {
    public static final String toDropTables = "temptables";
    public static final String toDropTablesJobId = SubmittedFields.jobid + "";
    public static final String toDropTablesTableName = "tablename";
    public static final String tempFolders = "tempfolders";
    public static final String tempFoldersJobId = SubmittedFields.jobid + "";
    public static final String tempFoldersFolderName = "foldername";
    public static final String selectedSpecies = "selectedspecies";
    public static final String selectedSpeciesStatus = SubmittedFields.status + "";
    public static final String selectedSpeciesJobId = SubmittedFields.jobid + "";
    public static final String selectedSpeciesSpeciesID = SpeciesOccursumFields.speciesid + "";
    public static final String selectedSpeciesIsCustomized = "iscustomized";
    protected static final String workingTables = "workingtables";
    protected static final String tableField = "tablename";
    protected static final String tableTypeField = "tabletype";

    protected static void setWorkingTable(int submittedId, String tableType, String tableName) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            logger.trace((Object)("inserting working table reference " + submittedId + ", " + tableType + " : " + tableName));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field(SubmittedFields.searchid + "", submittedId + "", FieldType.INTEGER));
            row.add(new Field(tableTypeField, tableType, FieldType.STRING));
            row.add(new Field("tablename", tableName, FieldType.STRING));
            rows.add(row);
            try {
                session.insertOperation(workingTables, rows);
            }
            catch (Exception e1) {
                logger.trace((Object)("trying toupdate working table reference " + submittedId + ", " + tableType + " : " + tableName));
                ArrayList<List<Field>> values = new ArrayList<List<Field>>();
                ArrayList<Field> value = new ArrayList<Field>();
                value.add(new Field("tablename", tableName, FieldType.STRING));
                values.add(row);
                ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
                ArrayList<Field> key = new ArrayList<Field>();
                key.add(new Field(SubmittedFields.searchid + "", submittedId + "", FieldType.INTEGER));
                key.add(new Field(tableTypeField, tableType, FieldType.STRING));
                keys.add(key);
                session.updateOperation(workingTables, keys, values);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    protected static String getWorkingTable(int submittedId, String tableType) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(SubmittedFields.searchid + "", submittedId + "", FieldType.INTEGER));
            filter.add(new Field(tableTypeField, tableType, FieldType.STRING));
            ResultSet rs = session.executeFilteredQuery(filter, workingTables, "tablename", OrderDirection.ASC);
            if (rs.next()) {
                String string = rs.getString("tablename");
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void setWorkingHCAF(int submittedId, String tableName) throws Exception {
        JobManager.setWorkingTable(submittedId, ResourceType.HCAF.toString(), tableName);
    }

    public static void setWorkingHSPEN(int submittedId, String tableName) throws Exception {
        JobManager.setWorkingTable(submittedId, ResourceType.HSPEN.toString(), tableName);
    }

    public static void setWorkingHSPEC(int submittedId, String tableName) throws Exception {
        JobManager.setWorkingTable(submittedId, ResourceType.HSPEC.toString(), tableName);
    }

    public static String getWorkingHCAF(int submittedId) throws Exception {
        return JobManager.getWorkingTable(submittedId, ResourceType.HCAF.toString());
    }

    public static String getWorkingHSPEN(int submittedId) throws Exception {
        return JobManager.getWorkingTable(submittedId, ResourceType.HSPEN.toString());
    }

    public static String getWorkingHSPEC(int submittedId) throws Exception {
        return JobManager.getWorkingTable(submittedId, ResourceType.HSPEC.toString());
    }

    public static void addToDropTableList(int jobId, String tableName) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field(toDropTablesJobId, jobId + "", FieldType.INTEGER));
            row.add(new Field("tablename", tableName, FieldType.STRING));
            rows.add(row);
            session.insertOperation(toDropTables, rows);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void addToDeleteTempFolder(int jobId, String folderName) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field(tempFoldersJobId, jobId + "", FieldType.INTEGER));
            row.add(new Field(tempFoldersFolderName, folderName, FieldType.STRING));
            rows.add(row);
            try {
                session.insertOperation(tempFolders, rows);
            }
            catch (Exception e) {
                logger.error((Object)"checking already inserted temp folders..");
                ArrayList<Field> filter = new ArrayList<Field>();
                filter.add(new Field(tempFoldersJobId, jobId + "", FieldType.INTEGER));
                boolean found = false;
                for (List f : Field.loadResultSet((ResultSet)session.executeFilteredQuery(filter, tempFolders, tempFoldersJobId, OrderDirection.ASC))) {
                    for (Field g : f) {
                        if (!g.getName().equals(tempFoldersFolderName) || !g.getValue().equals(folderName)) continue;
                        found = true;
                    }
                }
                if (!found) {
                    logger.warn((Object)("Unable to register temp folder " + folderName));
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void updateSpeciesStatus(int jobId, String[] speciesId, SpeciesStatus status) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> values = new ArrayList<List<Field>>();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            for (String id : speciesId) {
                ArrayList<Field> value = new ArrayList<Field>();
                value.add(new Field(selectedSpeciesStatus, (Object)((Object)status) + "", FieldType.STRING));
                values.add(value);
                ArrayList<Field> key = new ArrayList<Field>();
                key.add(new Field(selectedSpeciesJobId, jobId + "", FieldType.INTEGER));
                key.add(new Field(selectedSpeciesSpeciesID, id, FieldType.STRING));
                keys.add(key);
            }
            if (values.size() > 0) {
                session.updateOperation(selectedSpecies, keys, values);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static String[] getSpeciesByStatus(int jobId, SpeciesStatus status) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filters = new ArrayList<Field>();
            filters.add(new Field(selectedSpeciesJobId, jobId + "", FieldType.INTEGER));
            if (status != null) {
                filters.add(new Field(selectedSpeciesStatus, (Object)((Object)status) + "", FieldType.STRING));
            }
            ResultSet rs = session.executeFilteredQuery(filters, selectedSpecies, selectedSpeciesStatus, OrderDirection.ASC);
            ArrayList<String> toReturn = new ArrayList<String>();
            while (rs.next()) {
                toReturn.add(rs.getString(selectedSpeciesSpeciesID));
            }
            String[] stringArray = toReturn.toArray(new String[toReturn.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static boolean isJobComplete(int jobId) throws Exception {
        DBSession session = null;
        try {
            logger.debug((Object)("Checking if " + jobId + " is completed.."));
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(SubmittedFields.jobid + "", jobId + "", FieldType.INTEGER));
            long count = session.getCount("submitted", filter);
            logger.debug((Object)("Found " + count + " aquamaps object for jobId "));
            Field statusField = new Field(SubmittedFields.status + "", SubmittedStatus.Error + "", FieldType.STRING);
            filter.add(statusField);
            long errorCount = session.getCount("submitted", filter);
            logger.debug((Object)("Found " + errorCount + " ERROR aquamaps object for jobId "));
            statusField.setValue(SubmittedStatus.Completed + "");
            long completedCount = session.getCount("submitted", filter);
            logger.debug((Object)("Found " + completedCount + " COMPLETED aquamaps object for jobId "));
            boolean bl = completedCount + errorCount - count == 0L;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void cleanTemp(int jobId) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            logger.debug((Object)("cleaning tables for : " + jobId));
            ArrayList<Object> filter = new ArrayList<Field>();
            filter.add(new Field(toDropTablesJobId, jobId + "", FieldType.INTEGER));
            ResultSet rs = session.executeFilteredQuery(filter, toDropTables, "tablename", OrderDirection.ASC);
            while (rs.next()) {
                String table = rs.getString("tablename");
                session.dropTable(table);
            }
            session.deleteOperation(toDropTables, filter);
            logger.debug((Object)("cleaning folders for : " + jobId));
            rs = session.executeFilteredQuery(filter, tempFolders, tempFoldersFolderName, OrderDirection.ASC);
            while (rs.next()) {
                String folder = rs.getString(tempFoldersFolderName);
                try {
                    ServiceUtils.deleteFile(folder);
                }
                catch (Exception e1) {
                    logger.debug((Object)("unable to delete temp Folder : " + folder), (Throwable)e1);
                }
            }
            session.deleteOperation(tempFolders, filter);
            logger.debug((Object)"Cleaning serialized requests / generation data for objects..");
            for (Submitted obj : JobManager.getObjects(jobId)) {
                try {
                    if (obj.getSerializedRequest() != null) {
                        ServiceUtils.deleteFile(obj.getSerializedRequest());
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to delete file " + obj.getSerializedRequest()), (Throwable)e);
                }
                try {
                    Generator.cleanData(obj);
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to clean generation data for obj " + obj), (Throwable)e);
                }
            }
            Submitted job = JobManager.getSubmittedById(jobId);
            try {
                ServiceUtils.deleteFile(job.getSerializedRequest());
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to delete serialized file " + job.getSerializedRequest()));
            }
            logger.debug((Object)("cleaning speceisSelection for : " + jobId));
            session.deleteOperation(selectedSpecies, filter);
            logger.debug((Object)("cleaning references to working tables for : " + jobId));
            filter = new ArrayList();
            filter.add(new Field(SubmittedFields.searchid + "", jobId + "", FieldType.INTEGER));
            session.deleteOperation(workingTables, filter);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static boolean isSpeciesListReady(int jobId, Set<String> toCheck) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(selectedSpeciesJobId, jobId + "", FieldType.INTEGER));
            Field idField = new Field(selectedSpeciesSpeciesID, "", FieldType.STRING);
            filter.add(idField);
            for (String id : toCheck) {
                idField.setValue(id);
                ResultSet rs = session.executeFilteredQuery(filter, selectedSpecies, selectedSpeciesSpeciesID, OrderDirection.ASC);
                if (rs.next()) {
                    if (rs.getString(selectedSpeciesStatus).equalsIgnoreCase((Object)((Object)SpeciesStatus.Ready) + "")) continue;
                    boolean bl = false;
                    return bl;
                }
                throw new Exception("SpeciesID " + id + " not found in jobId " + jobId + " selection");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static boolean isSpeciesSetCustomized(int submittedId, Set<String> ids) throws Exception {
        DBSession session = null;
        try {
            logger.trace((Object)"Checking species customizations flag..");
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(selectedSpeciesJobId, submittedId + "", FieldType.INTEGER));
            Field idField = new Field(selectedSpeciesSpeciesID, "", FieldType.STRING);
            filter.add(idField);
            for (String id : ids) {
                idField.setValue(id);
                ResultSet rs = session.executeFilteredQuery(filter, selectedSpecies, selectedSpeciesSpeciesID, OrderDirection.ASC);
                if (rs.next()) {
                    if (rs.getInt(selectedSpeciesIsCustomized) != 0) continue;
                    boolean bl = false;
                    return bl;
                }
                throw new Exception("SpeciesID " + id + " not found in jobId " + submittedId + " selection");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)"unable to check species customization flag", (Throwable)e);
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static Job insertNewJob(Job toPerform) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            session.disableAutoCommit();
            logger.trace((Object)"Inserting references into internal DB...");
            PreparedStatement ps = null;
            PreparedStatement psCompleted = null;
            ArrayList<Field> row = null;
            ResultSet rs = null;
            Submitted submittedJob = JobManager.getSubmittedById(toPerform.getId());
            logger.debug((Object)("Submitted Job is " + submittedJob.toXML()));
            for (AquaMapsObject obj : toPerform.getAquaMapsObjectList()) {
                boolean customized = false;
                for (Species s : obj.getSelectedSpecies()) {
                    if (!toPerform.getEnvelopeCustomization().containsKey(s.getId()) && !toPerform.getEnvelopeWeights().containsKey(s.getId())) continue;
                    customized = true;
                    break;
                }
                String serializedObjectPath = ServiceContext.getContext().getFolderPath(ServiceContext.FOLDERS.SERIALIZED) + File.separator + ServiceUtils.generateId("OBJ", ".xml");
                AquaMapsXStream.serialize((String)serializedObjectPath, (Object)obj);
                String speciesCoverage = obj.getCompressedSpeciesCoverage();
                row = new ArrayList<Field>();
                row.add(submittedJob.getField(SubmittedFields.author));
                row.add(new Field(SubmittedFields.gisenabled + "", obj.getGis() + "", FieldType.BOOLEAN));
                row.add(new Field(SubmittedFields.isaquamap + "", "true", FieldType.BOOLEAN));
                row.add(new Field(SubmittedFields.jobid + "", submittedJob.getSearchId() + "", FieldType.INTEGER));
                row.add(new Field(SubmittedFields.saved + "", "false", FieldType.BOOLEAN));
                row.add(submittedJob.getField(SubmittedFields.sourcehcaf));
                row.add(submittedJob.getField(SubmittedFields.sourcehspec));
                row.add(submittedJob.getField(SubmittedFields.sourcehspen));
                row.add(submittedJob.getField(SubmittedFields.submissiontime));
                row.add(new Field(SubmittedFields.title + "", obj.getName(), FieldType.STRING));
                row.add(new Field(SubmittedFields.type + "", obj.getType() + "", FieldType.STRING));
                row.add(new Field(SubmittedFields.iscustomized + "", customized + "", FieldType.BOOLEAN));
                row.add(new Field(SubmittedFields.speciescoverage + "", speciesCoverage, FieldType.STRING));
                row.add(new Field(SubmittedFields.serializedobject + "", serializedObjectPath, FieldType.STRING));
                row.add(new Field(SubmittedFields.todelete + "", "false", FieldType.BOOLEAN));
                row.add(submittedJob.getField(SubmittedFields.forceregeneration));
                if (!customized && !submittedJob.isForceRegeneration().booleanValue()) {
                    Submitted toUse;
                    List<Submitted> alreadyGenerated = AquaMapsManager.getObjectsByCoverage(toPerform.getSourceHSPEC().getSearchId(), speciesCoverage, obj.getGis(), false);
                    logger.debug((Object)("Found " + alreadyGenerated.size() + " generated objects"));
                    if (alreadyGenerated.size() > 0) {
                        toUse = alreadyGenerated.get(0);
                        row.add(toUse.getField(SubmittedFields.filesetid));
                        if (obj.getGis().booleanValue()) {
                            row.add(toUse.getField(SubmittedFields.gispublishedid));
                        }
                        row.add(new Field(SubmittedFields.starttime + "", System.currentTimeMillis() + "", FieldType.LONG));
                        row.add(new Field(SubmittedFields.endtime + "", System.currentTimeMillis() + "", FieldType.LONG));
                        row.add(new Field(SubmittedFields.status + "", SubmittedStatus.Completed + "", FieldType.STRING));
                        obj.setStatus(SubmittedStatus.Completed);
                    } else {
                        if (obj.getGis().booleanValue()) {
                            logger.debug((Object)"No GIS already generated, looking for img fileset..");
                            alreadyGenerated = AquaMapsManager.getObjectsByCoverage(toPerform.getSourceHSPEC().getSearchId(), obj.getCompressedSpeciesCoverage(), false, false);
                            logger.debug((Object)("Found " + alreadyGenerated.size() + " generated objects"));
                            if (alreadyGenerated.size() > 0) {
                                toUse = alreadyGenerated.get(0);
                                row.add(toUse.getField(SubmittedFields.filesetid));
                            }
                        }
                        row.add(new Field(SubmittedFields.status + "", SubmittedStatus.Pending + "", FieldType.STRING));
                    }
                } else {
                    row.add(new Field(SubmittedFields.status + "", SubmittedStatus.Pending + "", FieldType.STRING));
                }
                if (obj.getStatus().equals((Object)SubmittedStatus.Completed)) {
                    if (psCompleted == null) {
                        psCompleted = session.getPreparedStatementForInsert(row, "submitted");
                    }
                    session.fillParameters(row, 0, psCompleted).executeUpdate();
                    rs = psCompleted.getGeneratedKeys();
                } else {
                    if (ps == null) {
                        ps = session.getPreparedStatementForInsert(row, "submitted");
                    }
                    session.fillParameters(row, 0, ps).executeUpdate();
                    rs = ps.getGeneratedKeys();
                }
                rs.next();
                obj.setId(rs.getInt(SubmittedFields.searchid + ""));
            }
            session.commit();
            if (JobManager.isJobComplete(toPerform.getId())) {
                JobManager.setStartTime(toPerform.getId());
                toPerform.setStatus(SubmittedStatus.Completed);
                logger.debug((Object)"All objects completed");
                if (toPerform.getIsGis().booleanValue()) {
                    // empty if block
                }
                JobManager.updateStatus(toPerform.getId(), SubmittedStatus.Completed);
            } else {
                if (toPerform.getSelectedSpecies().size() > 0) {
                    boolean hasPerturbation = false;
                    if (toPerform.getEnvelopeCustomization().size() > 0) {
                        hasPerturbation = true;
                    }
                    boolean hasWeight = false;
                    if (toPerform.getEnvelopeWeights().size() > 0) {
                        hasWeight = true;
                    }
                    ArrayList<Field> fields = new ArrayList<Field>();
                    fields.add(new Field(selectedSpeciesJobId, "", FieldType.INTEGER));
                    fields.add(new Field(selectedSpeciesSpeciesID, "", FieldType.STRING));
                    fields.add(new Field(selectedSpeciesStatus, "", FieldType.STRING));
                    fields.add(new Field(selectedSpeciesIsCustomized, "", FieldType.BOOLEAN));
                    PreparedStatement psSpecies = session.getPreparedStatementForInsert(fields, selectedSpecies);
                    ((Field)fields.get(0)).setValue(toPerform.getId() + "");
                    for (Species s : toPerform.getSelectedSpecies()) {
                        String status = SpeciesStatus.Ready.toString();
                        if (hasWeight && toPerform.getEnvelopeWeights().containsKey(s.getId())) {
                            status = SpeciesStatus.toGenerate.toString();
                        }
                        if (hasPerturbation && toPerform.getEnvelopeCustomization().containsKey(s.getId())) {
                            status = SpeciesStatus.toCustomize.toString();
                        }
                        ((Field)fields.get(1)).setValue(s.getId());
                        ((Field)fields.get(2)).setValue(status);
                        ((Field)fields.get(3)).setValue((hasWeight || hasPerturbation) + "");
                        psSpecies = session.fillParameters(fields, 0, psSpecies);
                        psSpecies.executeUpdate();
                    }
                } else {
                    throw new Exception("Invalid job, no species found");
                }
                JobManager.setWorkingHCAF(toPerform.getId(), SourceManager.getSourceName(toPerform.getSourceHCAF().getSearchId()));
                JobManager.setWorkingHSPEC(toPerform.getId(), SourceManager.getSourceName(toPerform.getSourceHSPEC().getSearchId()));
                JobManager.setWorkingHSPEN(toPerform.getId(), SourceManager.getSourceName(toPerform.getSourceHSPEN().getSearchId()));
                AquaMapsXStream.serialize((String)submittedJob.getSerializedRequest(), (Object)toPerform);
            }
            session.commit();
            Job job = toPerform;
            return job;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<Submitted> getObjects(int jobId) throws Exception {
        ArrayList<Field> filters = new ArrayList<Field>();
        Field jobIdField = new Field();
        jobIdField.setValue(jobId + "");
        jobIdField.setType(FieldType.INTEGER);
        jobIdField.setName(SubmittedFields.jobid + "");
        filters.add(jobIdField);
        return JobManager.getList(filters);
    }
}

